# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper


class UsageTriggerUpdateRequest(object):

    """Implementation of the 'UsageTriggerUpdateRequest' model.

    TODO: type model description here.

    Attributes:
        trigger_name (str): Usage trigger name
        account_name (str): Account name
        threshold_value (str): The percent of subscribed usage required to
            activate the trigger, such as 90 or 100.
        sms_phone_numbers (str): Comma-separated list of phone numbers to send
            SMS alerts to. Digits only; no dashes or parentheses, etc.
        email_addresses (str): Comma-separated list of email addresses to send
            alerts to.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_name": 'accountName',
        "trigger_name": 'triggerName',
        "threshold_value": 'thresholdValue',
        "sms_phone_numbers": 'smsPhoneNumbers',
        "email_addresses": 'emailAddresses'
    }

    _optionals = [
        'trigger_name',
        'threshold_value',
        'sms_phone_numbers',
        'email_addresses',
    ]

    def __init__(self,
                 account_name=None,
                 trigger_name=APIHelper.SKIP,
                 threshold_value=APIHelper.SKIP,
                 sms_phone_numbers=APIHelper.SKIP,
                 email_addresses=APIHelper.SKIP):
        """Constructor for the UsageTriggerUpdateRequest class"""

        # Initialize members of the class
        if trigger_name is not APIHelper.SKIP:
            self.trigger_name = trigger_name 
        self.account_name = account_name 
        if threshold_value is not APIHelper.SKIP:
            self.threshold_value = threshold_value 
        if sms_phone_numbers is not APIHelper.SKIP:
            self.sms_phone_numbers = sms_phone_numbers 
        if email_addresses is not APIHelper.SKIP:
            self.email_addresses = email_addresses 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_name = dictionary.get("accountName") if dictionary.get("accountName") else None
        trigger_name = dictionary.get("triggerName") if dictionary.get("triggerName") else APIHelper.SKIP
        threshold_value = dictionary.get("thresholdValue") if dictionary.get("thresholdValue") else APIHelper.SKIP
        sms_phone_numbers = dictionary.get("smsPhoneNumbers") if dictionary.get("smsPhoneNumbers") else APIHelper.SKIP
        email_addresses = dictionary.get("emailAddresses") if dictionary.get("emailAddresses") else APIHelper.SKIP
        # Return an object of this model
        return cls(account_name,
                   trigger_name,
                   threshold_value,
                   sms_phone_numbers,
                   email_addresses)
