# -*- coding: utf-8 -*-

"""
verizon

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon.api_helper import APIHelper
from verizon.models.v2_software_info import V2SoftwareInfo


class V2AccountDevice(object):

    """Implementation of the 'V2AccountDevice' model.

    Account device information.

    Attributes:
        device_id (str): Device identifier.
        mdn (str): MDN.
        model (str): Device model.
        make (str): Device make.
        fota_eligible (bool): Device FOTA capable.
        app_fota_eligible (bool): Device application FOTA capable.
        license_assigned (bool): License assigned device.
        distribution_type (str): LWM2M, OMD-DM or HTTP.
        software_list (List[V2SoftwareInfo]): List of sofware.
        create_time (str): The date and time of when the device is created.
        upgrade_time (str): The date and time of when the device firmware or
            software is upgraded.
        update_time (str): The date and time of when the device is updated.
        refresh_time (str): The date and time of when the device is
            refreshed.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "device_id": 'deviceId',
        "mdn": 'mdn',
        "model": 'model',
        "make": 'make',
        "fota_eligible": 'fotaEligible',
        "app_fota_eligible": 'appFotaEligible',
        "license_assigned": 'licenseAssigned',
        "distribution_type": 'distributionType',
        "software_list": 'softwareList',
        "create_time": 'createTime',
        "upgrade_time": 'upgradeTime',
        "update_time": 'updateTime',
        "refresh_time": 'refreshTime'
    }

    _optionals = [
        'create_time',
        'upgrade_time',
        'update_time',
        'refresh_time',
    ]

    def __init__(self,
                 device_id=None,
                 mdn=None,
                 model=None,
                 make=None,
                 fota_eligible=None,
                 app_fota_eligible=None,
                 license_assigned=None,
                 distribution_type=None,
                 software_list=None,
                 create_time=APIHelper.SKIP,
                 upgrade_time=APIHelper.SKIP,
                 update_time=APIHelper.SKIP,
                 refresh_time=APIHelper.SKIP):
        """Constructor for the V2AccountDevice class"""

        # Initialize members of the class
        self.device_id = device_id 
        self.mdn = mdn 
        self.model = model 
        self.make = make 
        self.fota_eligible = fota_eligible 
        self.app_fota_eligible = app_fota_eligible 
        self.license_assigned = license_assigned 
        self.distribution_type = distribution_type 
        self.software_list = software_list 
        if create_time is not APIHelper.SKIP:
            self.create_time = create_time 
        if upgrade_time is not APIHelper.SKIP:
            self.upgrade_time = upgrade_time 
        if update_time is not APIHelper.SKIP:
            self.update_time = update_time 
        if refresh_time is not APIHelper.SKIP:
            self.refresh_time = refresh_time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        device_id = dictionary.get("deviceId") if dictionary.get("deviceId") else None
        mdn = dictionary.get("mdn") if dictionary.get("mdn") else None
        model = dictionary.get("model") if dictionary.get("model") else None
        make = dictionary.get("make") if dictionary.get("make") else None
        fota_eligible = dictionary.get("fotaEligible") if "fotaEligible" in dictionary.keys() else None
        app_fota_eligible = dictionary.get("appFotaEligible") if "appFotaEligible" in dictionary.keys() else None
        license_assigned = dictionary.get("licenseAssigned") if "licenseAssigned" in dictionary.keys() else None
        distribution_type = dictionary.get("distributionType") if dictionary.get("distributionType") else None
        software_list = None
        if dictionary.get('softwareList') is not None:
            software_list = [V2SoftwareInfo.from_dictionary(x) for x in dictionary.get('softwareList')]
        create_time = dictionary.get("createTime") if dictionary.get("createTime") else APIHelper.SKIP
        upgrade_time = dictionary.get("upgradeTime") if dictionary.get("upgradeTime") else APIHelper.SKIP
        update_time = dictionary.get("updateTime") if dictionary.get("updateTime") else APIHelper.SKIP
        refresh_time = dictionary.get("refreshTime") if dictionary.get("refreshTime") else APIHelper.SKIP
        # Return an object of this model
        return cls(device_id,
                   mdn,
                   model,
                   make,
                   fota_eligible,
                   app_fota_eligible,
                   license_assigned,
                   distribution_type,
                   software_list,
                   create_time,
                   upgrade_time,
                   update_time,
                   refresh_time)
