/*
 * Decompiled with CFR 0.152.
 */
package thunder.streaming;

import org.apache.spark.SparkConf;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import thunder.streaming.StreamingKMeans;
import thunder.util.LoadStreaming$;

public final class StreamingKMeans$
implements Serializable {
    public static final StreamingKMeans$ MODULE$;

    static {
        new StreamingKMeans$();
    }

    public DStream<Object> trainStreaming(DStream<Vector> input, int k, int d, double a, int maxIterations, String initializationMode) {
        return new StreamingKMeans().setK(k).setD(d).setAlpha(a).setMaxIterations(maxIterations).setInitializationMode(initializationMode).runStreaming(input);
    }

    public void main(String[] args) {
        Tuple8 tuple8;
        if (args.length != 8) {
            System.err.println("Usage: StreamingKMeans <master> <directory> <batchTime> <k> <d> <a> <maxIterations> <initializationMode>");
            System.exit(1);
        }
        if ((tuple8 = new Tuple8((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(args[2])).toLong()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt()), (Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(args[5])).toDouble()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[6])).toInt()), (Object)args[7])) != null) {
            Tuple8 tuple82;
            String master = (String)tuple8._1();
            String directory = (String)tuple8._2();
            long batchTime = BoxesRunTime.unboxToLong((Object)tuple8._3());
            int k = BoxesRunTime.unboxToInt((Object)tuple8._4());
            int d = BoxesRunTime.unboxToInt((Object)tuple8._5());
            double a = BoxesRunTime.unboxToDouble((Object)tuple8._6());
            int maxIterations = BoxesRunTime.unboxToInt((Object)tuple8._7());
            String initializationMode = (String)tuple8._8();
            Tuple8 tuple83 = tuple82 = new Tuple8((Object)master, (Object)directory, (Object)BoxesRunTime.boxToLong((long)batchTime), (Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)d), (Object)BoxesRunTime.boxToDouble((double)a), (Object)BoxesRunTime.boxToInteger((int)maxIterations), (Object)initializationMode);
            String master2 = (String)tuple83._1();
            String directory2 = (String)tuple83._2();
            long batchTime2 = BoxesRunTime.unboxToLong((Object)tuple83._3());
            int k2 = BoxesRunTime.unboxToInt((Object)tuple83._4());
            int d2 = BoxesRunTime.unboxToInt((Object)tuple83._5());
            double a2 = BoxesRunTime.unboxToDouble((Object)tuple83._6());
            int maxIterations2 = BoxesRunTime.unboxToInt((Object)tuple83._7());
            String initializationMode2 = (String)tuple83._8();
            SparkConf conf = new SparkConf().setMaster(master2).setAppName("StreamingKMeans");
            Object object = master2.contains("local") ? BoxedUnit.UNIT : conf.setSparkHome(System.getenv("SPARK_HOME")).setJars((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target/scala-2.10/thunder_2.10-0.1.0.jar"}))).set("spark.executor.memory", "100G");
            StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(batchTime2));
            DStream data = LoadStreaming$.MODULE$.fromText(ssc, directory2).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Vector apply(double[] x) {
                    return Vectors$.MODULE$.dense(x);
                }
            }, ClassTag$.MODULE$.apply(Vector.class));
            DStream<Object> assignments = this.trainStreaming((DStream<Vector>)data, k2, d2, a2, maxIterations2, initializationMode2);
            assignments.print();
            ssc.start();
            ssc.awaitTermination();
            return;
        }
        throw new MatchError((Object)tuple8);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StreamingKMeans$() {
        MODULE$ = this;
    }
}

