/*
 * Decompiled with CFR 0.152.
 */
package thunder.streaming;

import org.apache.spark.SparkConf;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import thunder.streaming.StreamingLinearRegression;
import thunder.util.LoadStreaming$;

public final class StreamingLinearRegression$ {
    public static final StreamingLinearRegression$ MODULE$;

    static {
        new StreamingLinearRegression$();
    }

    public DStream<Object> trainStreaming(DStream<LabeledPoint> input, int d, double stepSize, int numIterations, String initializationMode) {
        return new StreamingLinearRegression(d, stepSize, numIterations, initializationMode).runStreaming(input);
    }

    public void main(String[] args) {
        Tuple7 tuple7;
        if (args.length != 7) {
            System.err.println("Usage: StreamingLinearRegression <master> <directory> <batchTime> <d> <stepSize> <numIterations> <initializationMode>");
            System.exit(1);
        }
        if ((tuple7 = new Tuple7((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(args[2])).toLong()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt()), (Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(args[4])).toDouble()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(args[5])).toInt()), (Object)args[6].toString())) != null) {
            Tuple7 tuple72;
            String master = (String)tuple7._1();
            String directory = (String)tuple7._2();
            long batchTime = BoxesRunTime.unboxToLong((Object)tuple7._3());
            int d = BoxesRunTime.unboxToInt((Object)tuple7._4());
            double stepSize = BoxesRunTime.unboxToDouble((Object)tuple7._5());
            int numIterations = BoxesRunTime.unboxToInt((Object)tuple7._6());
            String initializationMode = (String)tuple7._7();
            Tuple7 tuple73 = tuple72 = new Tuple7((Object)master, (Object)directory, (Object)BoxesRunTime.boxToLong((long)batchTime), (Object)BoxesRunTime.boxToInteger((int)d), (Object)BoxesRunTime.boxToDouble((double)stepSize), (Object)BoxesRunTime.boxToInteger((int)numIterations), (Object)initializationMode);
            String master2 = (String)tuple73._1();
            String directory2 = (String)tuple73._2();
            long batchTime2 = BoxesRunTime.unboxToLong((Object)tuple73._3());
            int d2 = BoxesRunTime.unboxToInt((Object)tuple73._4());
            double stepSize2 = BoxesRunTime.unboxToDouble((Object)tuple73._5());
            int numIterations2 = BoxesRunTime.unboxToInt((Object)tuple73._6());
            String initializationMode2 = (String)tuple73._7();
            SparkConf conf = new SparkConf().setMaster(master2).setAppName("StreamingLinearRegression");
            Object object = master2.contains("local") ? BoxedUnit.UNIT : conf.setSparkHome(System.getenv("SPARK_HOME")).setJars((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target/scala-2.10/thunder_2.10-0.1.0.jar"}))).set("spark.executor.memory", "100G");
            StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(batchTime2));
            DStream<LabeledPoint> data = LoadStreaming$.MODULE$.fromTextWithLabels(ssc, directory2);
            DStream<Object> predictions = this.trainStreaming(data, d2, stepSize2, numIterations2, initializationMode2);
            predictions.print();
            ssc.start();
            ssc.awaitTermination();
            return;
        }
        throw new MatchError((Object)tuple7);
    }

    private StreamingLinearRegression$() {
        MODULE$ = this;
    }
}

