/*
 * Decompiled with CFR 0.152.
 */
package thunder.streaming;

import org.apache.spark.SparkConf;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.dstream.DStream;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import thunder.streaming.BinnedStats;
import thunder.streaming.StatefulBinnedStats;
import thunder.util.LoadParam$;
import thunder.util.LoadStreaming$;
import thunder.util.SaveStreaming$;
import thunder.util.ThunderParam;
import thunder.util.io.Keys$;

public final class StatefulBinnedStats$
implements Serializable {
    public static final StatefulBinnedStats$ MODULE$;

    static {
        new StatefulBinnedStats$();
    }

    public DStream<Tuple2<Object, BinnedStats>> trainStreaming(DStream<Tuple2<Object, double[]>> input, int[] featureKeys, int featureCount) {
        return new StatefulBinnedStats().setFeatureKeys(featureKeys).setFeatureCount(featureCount).runStreaming(input);
    }

    public void main(String[] args) {
        Tuple5 tuple5;
        if (args.length != 5) {
            System.err.println("Usage: StatefulBinnedStats <master> <directory> <batchTime> <outputDirectory> <paramFile>");
            System.exit(1);
        }
        if ((tuple5 = new Tuple5((Object)args[0], (Object)args[1], (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(args[2])).toLong()), (Object)args[3], (Object)args[4])) != null) {
            Tuple5 tuple52;
            String master = (String)tuple5._1();
            String directory = (String)tuple5._2();
            long batchTime = BoxesRunTime.unboxToLong((Object)tuple5._3());
            String outputDirectory = (String)tuple5._4();
            String paramFile = (String)tuple5._5();
            Tuple5 tuple53 = tuple52 = new Tuple5((Object)master, (Object)directory, (Object)BoxesRunTime.boxToLong((long)batchTime), (Object)outputDirectory, (Object)paramFile);
            String master2 = (String)tuple53._1();
            String directory2 = (String)tuple53._2();
            long batchTime2 = BoxesRunTime.unboxToLong((Object)tuple53._3());
            String outputDirectory2 = (String)tuple53._4();
            String paramFile2 = (String)tuple53._5();
            SparkConf conf = new SparkConf().setMaster(master2).setAppName("StatefulStats");
            Object object = master2.contains("local") ? BoxedUnit.UNIT : conf.setSparkHome(System.getenv("SPARK_HOME")).setJars((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target/scala-2.10/thunder_2.10-0.1.0.jar"}))).set("spark.executor.memory", "100G").set("spark.default.parallelism", "100");
            StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(batchTime2));
            ssc.checkpoint(System.getenv("CHECKPOINT"));
            ThunderParam params = LoadParam$.MODULE$.fromText(paramFile2);
            int[] binKeys = Keys$.MODULE$.subToInd(params.getBinKeys(), params.getDims());
            double[][] binValues = params.getBinValues();
            String[] binName = params.getBinName();
            DStream<Tuple2<Object, double[]>> data = LoadStreaming$.MODULE$.fromBinaryWithKeys(ssc, directory2, Predef$.MODULE$.intArrayOps(params.getDims()).size(), params.getDims(), "short");
            DStream<Tuple2<Object, BinnedStats>> state = this.trainStreaming(data, binKeys, binValues[0].length);
            DStream result = StreamingContext$.MODULE$.toPairDStreamFunctions(state, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(BinnedStats.class), (Ordering)Ordering.Int$.MODULE$).mapValues((Function1)new Serializable(binValues){
                public static final long serialVersionUID = 0L;
                private final double[][] binValues$1;

                public final double[] apply(BinnedStats x) {
                    return new double[]{x.r2(), x.weightedMean(this.binValues$1[0])};
                }
                {
                    this.binValues$1 = binValues$1;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            SaveStreaming$.MODULE$.asBinaryWithKeys((DStream<Tuple2<Object, double[]>>)result, outputDirectory2, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"r2-").append((Object)binName[0]).toString(), new StringBuilder().append((Object)"tuning-").append((Object)binName[0]).toString()}))));
            ssc.start();
            ssc.awaitTermination();
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StatefulBinnedStats$() {
        MODULE$ = this;
    }
}

