/*
 * Decompiled with CFR 0.152.
 */
package thunder.streaming;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.streaming.StreamingLinearRegressionWithSGD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.dstream.DStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.util.Random$;
import thunder.streaming.StreamingLinearRegression$;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001\u001d\u0011\u0011d\u0015;sK\u0006l\u0017N\\4MS:,\u0017M\u001d*fOJ,7o]5p]*\u00111\u0001B\u0001\ngR\u0014X-Y7j]\u001eT\u0011!B\u0001\bi\",h\u000eZ3s\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011!y\u0001A!a\u0001\n\u0003\u0001\u0012!\u00013\u0016\u0003E\u0001\"!\u0003\n\n\u0005MQ!aA%oi\"AQ\u0003\u0001BA\u0002\u0013\u0005a#A\u0003e?\u0012*\u0017\u000f\u0006\u0002\u00185A\u0011\u0011\u0002G\u0005\u00033)\u0011A!\u00168ji\"91\u0004FA\u0001\u0002\u0004\t\u0012a\u0001=%c!AQ\u0004\u0001B\u0001B\u0003&\u0011#\u0001\u0002eA!Aq\u0004\u0001BA\u0002\u0013\u0005\u0001%\u0001\u0005ti\u0016\u00048+\u001b>f+\u0005\t\u0003CA\u0005#\u0013\t\u0019#B\u0001\u0004E_V\u0014G.\u001a\u0005\tK\u0001\u0011\t\u0019!C\u0001M\u0005a1\u000f^3q'&TXm\u0018\u0013fcR\u0011qc\n\u0005\b7\u0011\n\t\u00111\u0001\"\u0011!I\u0003A!A!B\u0013\t\u0013!C:uKB\u001c\u0016N_3!\u0011!Y\u0003A!a\u0001\n\u0003\u0001\u0012!\u00048v[&#XM]1uS>t7\u000f\u0003\u0005.\u0001\t\u0005\r\u0011\"\u0001/\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0003/=Bqa\u0007\u0017\u0002\u0002\u0003\u0007\u0011\u0003\u0003\u00052\u0001\t\u0005\t\u0015)\u0003\u0012\u00039qW/\\%uKJ\fG/[8og\u0002B\u0001b\r\u0001\u0003\u0002\u0004%\t\u0001N\u0001\u0013S:LG/[1mSj\fG/[8o\u001b>$W-F\u00016!\t1\u0014H\u0004\u0002\no%\u0011\u0001HC\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029\u0015!AQ\b\u0001BA\u0002\u0013\u0005a(\u0001\fj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,w\fJ3r)\t9r\bC\u0004\u001cy\u0005\u0005\t\u0019A\u001b\t\u0011\u0005\u0003!\u0011!Q!\nU\n1#\u001b8ji&\fG.\u001b>bi&|g.T8eK\u0002BQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0001P5oSRtD#B#H\u0011&S\u0005C\u0001$\u0001\u001b\u0005\u0011\u0001\"B\bC\u0001\u0004\t\u0002\"B\u0010C\u0001\u0004\t\u0003\"B\u0016C\u0001\u0004\t\u0002\"B\u001aC\u0001\u0004)\u0004\"B\"\u0001\t\u0003aE#A#\t\u000f9\u0003!\u0019!C\u0001\u001f\u0006I\u0011\r\\4pe&$\b.\\\u000b\u0002!B\u0011\u0011kW\u0007\u0002%*\u00111a\u0015\u0006\u0003)V\u000bQ!\u001c7mS\nT!AV,\u0002\u000bM\u0004\u0018M]6\u000b\u0005aK\u0016AB1qC\u000eDWMC\u0001[\u0003\ry'oZ\u0005\u00039J\u0013\u0001e\u0015;sK\u0006l\u0017N\\4MS:,\u0017M\u001d*fOJ,7o]5p]^KG\u000f[*H\t\"1a\f\u0001Q\u0001\nA\u000b!\"\u00197h_JLG\u000f[7!\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003\u0011\u0019X\r\u001e#\u0015\u0005\u0015\u0013\u0007\"B\b`\u0001\u0004\t\u0002\"\u00023\u0001\t\u0003)\u0017!F:fi&s\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u000b\u0003\u000b\u001aDQaM2A\u0002UBQ\u0001\u001b\u0001\u0005\u0002%\f\u0011\"\u001b8ji\u001aK\u00070\u001a3\u0015\u0003)\u0004\"a\u001b8\u000e\u00031T!!\\*\u0002\u0015I,wM]3tg&|g.\u0003\u0002pY\n)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007\"B9\u0001\t\u0003I\u0017AC5oSR\u0014\u0016M\u001c3p[\")1\u000f\u0001C\u0001i\u00061Q\u000f\u001d3bi\u0016$2A[;\u0000\u0011\u00151(\u000f1\u0001x\u0003\r\u0011H\r\u001a\t\u0004qjdX\"A=\u000b\u0005Y,\u0016BA>z\u0005\r\u0011F\t\u0012\t\u0003WvL!A 7\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\r\u0005\u0005!\u000f1\u0001k\u0003\u0015iw\u000eZ3m\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\tAB];o'R\u0014X-Y7j]\u001e$B!!\u0003\u0002\u0018A)\u00111BA\nC5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0004egR\u0014X-Y7\u000b\u0005\r)\u0016\u0002BA\u000b\u0003\u001b\u0011q\u0001R*ue\u0016\fW\u000e\u0003\u0005\u0002\u001a\u0005\r\u0001\u0019AA\u000e\u0003\u0011!\u0017\r^1\u0011\u000b\u0005-\u00111\u0003?\b\u000f\u0005}!\u0001#\u0001\u0002\"\u0005I2\u000b\u001e:fC6Lgn\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o!\r1\u00151\u0005\u0004\u0007\u0003\tA\t!!\n\u0014\u0007\u0005\r\u0002\u0002C\u0004D\u0003G!\t!!\u000b\u0015\u0005\u0005\u0005\u0002\u0002CA\u0017\u0003G!\t!a\f\u0002\u001dQ\u0014\u0018-\u001b8TiJ,\u0017-\\5oORa\u0011\u0011BA\u0019\u0003k\t9$!\u000f\u0002<!A\u00111GA\u0016\u0001\u0004\tY\"A\u0003j]B,H\u000f\u0003\u0004\u0010\u0003W\u0001\r!\u0005\u0005\u0007?\u0005-\u0002\u0019A\u0011\t\r-\nY\u00031\u0001\u0012\u0011\u0019\u0019\u00141\u0006a\u0001k!A\u0011qHA\u0012\t\u0003\t\t%\u0001\u0003nC&tGcA\f\u0002D!A\u0011QIA\u001f\u0001\u0004\t9%\u0001\u0003be\u001e\u001c\b\u0003B\u0005\u0002JUJ1!a\u0013\u000b\u0005\u0015\t%O]1z\u0001")
public class StreamingLinearRegression {
    private int d;
    private double stepSize;
    private int numIterations;
    private String initializationMode;
    private final StreamingLinearRegressionWithSGD algorithm;

    public static void main(String[] stringArray) {
        StreamingLinearRegression$.MODULE$.main(stringArray);
    }

    public static DStream<Object> trainStreaming(DStream<LabeledPoint> dStream, int n, double d, int n2, String string) {
        return StreamingLinearRegression$.MODULE$.trainStreaming(dStream, n, d, n2, string);
    }

    public int d() {
        return this.d;
    }

    public void d_$eq(int x$1) {
        this.d = x$1;
    }

    public double stepSize() {
        return this.stepSize;
    }

    public void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    public int numIterations() {
        return this.numIterations;
    }

    public void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    public String initializationMode() {
        return this.initializationMode;
    }

    public void initializationMode_$eq(String x$1) {
        this.initializationMode = x$1;
    }

    public StreamingLinearRegressionWithSGD algorithm() {
        return this.algorithm;
    }

    public StreamingLinearRegression setD(int d) {
        this.d_$eq(d);
        return this;
    }

    public StreamingLinearRegression setInitializationMode(String initializationMode) {
        block3: {
            block2: {
                String string = initializationMode;
                String string2 = "random";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = initializationMode;
                String string4 = "fixed";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.initializationMode_$eq(initializationMode);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid initialization mode: ").append((Object)initializationMode).toString());
    }

    public LinearRegressionModel initFixed() {
        Vector weights = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.d(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }, ClassTag$.MODULE$.Double()));
        double intercept = 0.0;
        return this.algorithm().createModel(weights, intercept);
    }

    public LinearRegressionModel initRandom() {
        Vector weights = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.d(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return Random$.MODULE$.nextGaussian();
            }
        }, ClassTag$.MODULE$.Double()));
        double intercept = Random$.MODULE$.nextGaussian();
        return this.algorithm().createModel(weights, intercept);
    }

    public LinearRegressionModel update(RDD<LabeledPoint> rdd, LinearRegressionModel model) {
        return rdd.count() != 0L ? (LinearRegressionModel)this.algorithm().run(rdd, model.weights()) : model;
    }

    public DStream<Object> runStreaming(DStream<LabeledPoint> data) {
        ObjectRef model = new ObjectRef((Object)this.initFixed());
        data.foreachRDD((Function1)new Serializable(this, model){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLinearRegression $outer;
            private final ObjectRef model$1;

            public final void apply(RDD<LabeledPoint> rdd) {
                this.model$1.elem = this.$outer.update(rdd, (LinearRegressionModel)this.model$1.elem);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.model$1 = model$1;
            }
        });
        return data.map((Function1)new Serializable(this, model){
            public static final long serialVersionUID = 0L;
            private final ObjectRef model$1;

            public final double apply(LabeledPoint x) {
                return ((LinearRegressionModel)this.model$1.elem).predict(x.features());
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public StreamingLinearRegression(int d, double stepSize, int numIterations, String initializationMode) {
        this.d = d;
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.initializationMode = initializationMode;
        this.algorithm = (StreamingLinearRegressionWithSGD)new StreamingLinearRegressionWithSGD(this.stepSize(), this.numIterations()).setIntercept(true);
    }

    public StreamingLinearRegression() {
        this(5, 1.0, 10, "fixed");
    }
}

