/*
 * Decompiled with CFR 0.152.
 */
package thunder.util.io.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import scala.reflect.ScalaSignature;
import thunder.util.io.hadoop.FixedLengthBinaryInputFormat$;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001-\u0011QDR5yK\u0012dUM\\4uQ\nKg.\u0019:z%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\ta\u0001[1e_>\u0004(BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u0005!Q\u000f^5m\u0015\u0005I\u0011a\u0002;ik:$WM]\u0002\u0001'\t\u0001A\u0002\u0005\u0003\u000e+]aR\"\u0001\b\u000b\u0005=\u0001\u0012!C7baJ,G-^2f\u0015\t\u0019\u0011C\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<\u0017B\u0001\f\u000f\u00051\u0011VmY8sIJ+\u0017\rZ3s!\tA\"$D\u0001\u001a\u0015\t)\u0001#\u0003\u0002\u001c3\taAj\u001c8h/JLG/\u00192mKB\u0011\u0001$H\u0005\u0003=e\u0011QBQ=uKN<&/\u001b;bE2,\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0003\u0011\u0015)\u0003\u0001\"\u0011'\u0003\u0015\u0019Gn\\:f)\u00059\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#\u0001B+oSRDQA\f\u0001\u0005B=\nQbZ3u\u0007V\u0014(/\u001a8u\u0017\u0016LH#A\f\t\u000bE\u0002A\u0011\t\u001a\u0002\u001f\u001d,GoQ;se\u0016tGOV1mk\u0016$\u0012\u0001\b\u0005\u0006i\u0001!\t%N\u0001\fO\u0016$\bK]8he\u0016\u001c8\u000fF\u00017!\tAs'\u0003\u00029S\t)a\t\\8bi\")!\b\u0001C!w\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007\u001db\u0014\tC\u0003>s\u0001\u0007a(\u0001\u0006j]B,Ho\u00159mSR\u0004\"!D \n\u0005\u0001s!AC%oaV$8\u000b\u001d7ji\")!)\u000fa\u0001\u0007\u000691m\u001c8uKb$\bCA\u0007E\u0013\t)eB\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\b\"B$\u0001\t\u0003B\u0015\u0001\u00048fqR\\U-\u001f,bYV,G#A%\u0011\u0005!R\u0015BA&*\u0005\u001d\u0011un\u001c7fC:Dq!\u0014\u0001A\u0002\u0013\u0005a*\u0001\u0006ta2LGo\u0015;beR,\u0012a\u0014\t\u0003QAK!!U\u0015\u0003\t1{gn\u001a\u0005\b'\u0002\u0001\r\u0011\"\u0001U\u00039\u0019\b\u000f\\5u'R\f'\u000f^0%KF$\"aJ+\t\u000fY\u0013\u0016\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\t\ra\u0003\u0001\u0015)\u0003P\u0003-\u0019\b\u000f\\5u'R\f'\u000f\u001e\u0011\t\u000fi\u0003\u0001\u0019!C\u0001\u001d\u0006A1\u000f\u001d7ji\u0016sG\rC\u0004]\u0001\u0001\u0007I\u0011A/\u0002\u0019M\u0004H.\u001b;F]\u0012|F%Z9\u0015\u0005\u001dr\u0006b\u0002,\\\u0003\u0003\u0005\ra\u0014\u0005\u0007A\u0002\u0001\u000b\u0015B(\u0002\u0013M\u0004H.\u001b;F]\u0012\u0004\u0003b\u00022\u0001\u0001\u0004%\tAT\u0001\u0010GV\u0014(/\u001a8u!>\u001c\u0018\u000e^5p]\"9A\r\u0001a\u0001\n\u0003)\u0017aE2veJ,g\u000e\u001e)pg&$\u0018n\u001c8`I\u0015\fHCA\u0014g\u0011\u001d16-!AA\u0002=Ca\u0001\u001b\u0001!B\u0013y\u0015\u0001E2veJ,g\u000e\u001e)pg&$\u0018n\u001c8!\u0011\u001dQ\u0007\u00011A\u0005\u0002-\fAB]3d_J$G*\u001a8hi\",\u0012\u0001\u001c\t\u0003Q5L!A\\\u0015\u0003\u0007%sG\u000fC\u0004q\u0001\u0001\u0007I\u0011A9\u0002!I,7m\u001c:e\u0019\u0016tw\r\u001e5`I\u0015\fHCA\u0014s\u0011\u001d1v.!AA\u00021Da\u0001\u001e\u0001!B\u0013a\u0017!\u0004:fG>\u0014H\rT3oORD\u0007\u0005C\u0004w\u0001\u0001\u0007I\u0011A<\u0002\u001f\u0019LG.Z%oaV$8\u000b\u001e:fC6,\u0012\u0001\u001f\t\u0003srl\u0011A\u001f\u0006\u0003wB\t!AZ:\n\u0005uT(!\u0005$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\"Aq\u0010\u0001a\u0001\n\u0003\t\t!A\ngS2,\u0017J\u001c9viN#(/Z1n?\u0012*\u0017\u000fF\u0002(\u0003\u0007AqA\u0016@\u0002\u0002\u0003\u0007\u0001\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0015\u0002=\u0002!\u0019LG.Z%oaV$8\u000b\u001e:fC6\u0004\u0003\"CA\u0006\u0001\u0001\u0007I\u0011AA\u0007\u0003%\u0011XmY8sI.+\u00170F\u0001\u0018\u0011%\t\t\u0002\u0001a\u0001\n\u0003\t\u0019\"A\u0007sK\u000e|'\u000fZ&fs~#S-\u001d\u000b\u0004O\u0005U\u0001\u0002\u0003,\u0002\u0010\u0005\u0005\t\u0019A\f\t\u000f\u0005e\u0001\u0001)Q\u0005/\u0005Q!/Z2pe\u0012\\U-\u001f\u0011\t\u0013\u0005u\u0001\u00011A\u0005\u0002\u0005}\u0011a\u0003:fG>\u0014HMV1mk\u0016,\u0012\u0001\b\u0005\n\u0003G\u0001\u0001\u0019!C\u0001\u0003K\tqB]3d_J$g+\u00197vK~#S-\u001d\u000b\u0004O\u0005\u001d\u0002\u0002\u0003,\u0002\"\u0005\u0005\t\u0019\u0001\u000f\t\u000f\u0005-\u0002\u0001)Q\u00059\u0005a!/Z2pe\u00124\u0016\r\\;fA\u0001")
public class FixedLengthBinaryRecordReader
extends RecordReader<LongWritable, BytesWritable> {
    private long splitStart = 0L;
    private long splitEnd = 0L;
    private long currentPosition = 0L;
    private int recordLength = 0;
    private FSDataInputStream fileInputStream = null;
    private LongWritable recordKey = null;
    private BytesWritable recordValue = null;

    public void close() {
        if (this.fileInputStream() != null) {
            this.fileInputStream().close();
        }
    }

    public LongWritable getCurrentKey() {
        return this.recordKey();
    }

    public BytesWritable getCurrentValue() {
        return this.recordValue();
    }

    public float getProgress() {
        long l = this.splitStart();
        float f = l == this.splitEnd() ? (float)0.0 : (float)Math.min((double)((this.currentPosition() - this.splitStart()) / (this.splitEnd() - this.splitStart())), 1.0);
        return f;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) {
        FileSplit fileSplit = (FileSplit)inputSplit;
        this.splitStart_$eq(fileSplit.getStart());
        this.splitEnd_$eq(this.splitStart() + fileSplit.getLength());
        Path file = fileSplit.getPath();
        Configuration job = context.getConfiguration();
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(file);
        if (codec == null) {
            this.recordLength_$eq(FixedLengthBinaryInputFormat$.MODULE$.getRecordLength((JobContext)context));
            FileSystem fs = file.getFileSystem(job);
            this.fileInputStream_$eq(fs.open(file));
            this.fileInputStream().seek(this.splitStart());
            this.currentPosition_$eq(this.splitStart());
            return;
        }
        throw new IOException("FixedLengthRecordReader does not support reading compressed files");
    }

    public boolean nextKeyValue() {
        if (this.recordKey() == null) {
            this.recordKey_$eq(new LongWritable());
        }
        this.recordKey().set(this.currentPosition() / (long)this.recordLength());
        if (this.recordValue() == null) {
            this.recordValue_$eq(new BytesWritable(new byte[this.recordLength()]));
        }
        if (this.currentPosition() < this.splitEnd()) {
            byte[] buffer = this.recordValue().getBytes();
            this.fileInputStream().readFully(buffer);
            this.currentPosition_$eq(this.currentPosition() + (long)this.recordLength());
            return true;
        }
        return false;
    }

    public long splitStart() {
        return this.splitStart;
    }

    public void splitStart_$eq(long x$1) {
        this.splitStart = x$1;
    }

    public long splitEnd() {
        return this.splitEnd;
    }

    public void splitEnd_$eq(long x$1) {
        this.splitEnd = x$1;
    }

    public long currentPosition() {
        return this.currentPosition;
    }

    public void currentPosition_$eq(long x$1) {
        this.currentPosition = x$1;
    }

    public int recordLength() {
        return this.recordLength;
    }

    public void recordLength_$eq(int x$1) {
        this.recordLength = x$1;
    }

    public FSDataInputStream fileInputStream() {
        return this.fileInputStream;
    }

    public void fileInputStream_$eq(FSDataInputStream x$1) {
        this.fileInputStream = x$1;
    }

    public LongWritable recordKey() {
        return this.recordKey;
    }

    public void recordKey_$eq(LongWritable x$1) {
        this.recordKey = x$1;
    }

    public BytesWritable recordValue() {
        return this.recordValue;
    }

    public void recordValue_$eq(BytesWritable x$1) {
        this.recordValue = x$1;
    }
}

