# Explicit mapping of builtin names to their actual functions
BUILTIN_FUNCTIONS = {
    "len": len,
    "range": range,
    "int": int,
    "float": float,
    "str": str,
    "bool": bool,
    "list": list,
    "dict": dict,
    "tuple": tuple,
    "set": set,
    "abs": abs,
    "min": min,
    "max": max,
    "sum": sum,
    "round": round,
    "sorted": sorted,
    "reversed": lambda x: list(reversed(x)),  # Special case: return list instead of iterator
    "enumerate": enumerate,
    "zip": zip,
    "all": all,
    "any": any,
    "isinstance": isinstance,
    "type": type,
}

# Set of allowed builtin names for validation (computed from BUILTIN_FUNCTIONS keys)
ALLOWED_BUILTINS = set(BUILTIN_FUNCTIONS.keys())

# Allowed methods for specific types
# These are safe methods that don't allow code execution or system access
ALLOWED_METHODS = {
    "str": {
        "upper",
        "lower",
        "strip",
        "lstrip",
        "rstrip",
        "capitalize",
        "title",
        "swapcase",
        "startswith",
        "endswith",
        "isdigit",
        "isalpha",
        "isalnum",
        "isspace",
        "islower",
        "isupper",
        "isdecimal",
        "isnumeric",
        "isascii",
        "isprintable",
        "isidentifier",
        "find",
        "rfind",
        "index",
        "rindex",
        "count",
        "replace",
        "split",
        "rsplit",
        "splitlines",
        "join",
        "center",
        "ljust",
        "rjust",
        "zfill",
        "format",
    },
    "list": {
        "append",
        "extend",
        "insert",
        "remove",
        "pop",
        "clear",
        "index",
        "count",
        "sort",
        "reverse",
        "copy",
    },
    "dict": {
        "keys",
        "values",
        "items",
        "get",
        "update",
    },
    "set": {
        "add",
        "remove",
        "clear",
    },
}
