from tkinter import *
from tkdev import (window_popup, window_custom_taskbar, WS_EX_TOOLWINDOW, CreateWindowEx, WS_VISIBLE, WS_EX_APPWINDOW,
                   SetWindowLong, GetParent, GWL_STYLE, ShowWindow, SW_SHOW, SW_HIDE, window_sizebox)
from typing import Literal


class DevPreTooltip(Toplevel):
    def __init__(self, widget: Widget, window: Tk, message: str = "", border: bool = True, side=CENTER,
                 background="#ffffff", foreground="#000000"):
        super(DevPreTooltip, self).__init__(background=background, relief=RAISED, border=1)
        if border:
            SetWindowLong(GetParent(self.winfo_id()), GWL_STYLE, ~WS_VISIBLE | WS_EX_TOOLWINDOW)

            window_popup(self)
        if not border:
            self.overrideredirect(True)

        self.withdraw()

        self.side = side

        self.widget = widget
        self.widget.bind("<Enter>", lambda evt: self.show(evt.x_root, evt.y_root), add="+")
        self.widget.bind("<Motion>", lambda evt: self.show(evt.x_root, evt.y_root), add="+")
        self.widget.bind("<Leave>", lambda evt: self.hide(), add="+")
        self.widget.bind("<ButtonPress>", lambda evt: self.hide(), add="+")
        self.window = Window

        self.message = StringVar()
        self.message.set(message)

        Message(self, textvariable=self.message, background=background, foreground=foreground).grid()

    def show(self, x, y):
        self.attributes("-topmost", True)
        if self.side == LEFT:
            self.geometry(f"+{x - int(self.winfo_width())}+{y + 10}")
        if self.side == CENTER:
            self.geometry(f"+{x - int(self.winfo_width() / 2)}+{y + 10}")
        if self.side == RIGHT:
            self.geometry(f"+{x}+{y + 10}")
        self.update()
        self.deiconify()

    def hide(self):
        self.attributes("-topmost", False)
        self.window.attributes("-topmost", True)
        self.withdraw()
        self.window.after(1000, lambda: self.window.attributes("-topmost", False))


if __name__ == '__main__':
    Window = Tk()

    Label = Label(Window, text="Hello")
    Tooltip = DevPreTooltip(Label, Window, message="Hello World", border=False, side=CENTER)
    Label.pack()

    Window.mainloop()
