import urllib.request
from os import mkdir, environ, system, remove
from os.path import exists, expanduser
from time import sleep


def console(text):
    print("控制台输出 : " + text)


def is64():
    return 'PROGRAMFILES(X86)' in environ


def install(url_file, path):
    import requests
    import zipfile
    console("开始下载 : " + url_file)

    urllib.request.urlretrieve(url_file, path)
    file = zipfile.ZipFile(path, "r")
    console("开始检验压缩包是否损坏...")
    file.testzip()
    for list in file.namelist():
        console("压缩包内的文件 : " + list)


console("获取个人文件夹中")
user_path = expanduser("~")
console("获取成功！位置在：" + user_path)
console("准备创建 .tkdev 文件夹...")
console("检测 .tkdev 是否已经存在...")
tkdev_path = user_path + "\\.tkdev"
if exists(tkdev_path):
    console("检测到 .tkdev 已经存在！")
else:
    console("未检测到 .tkdev ，准备开始创建 .tkdev 文件夹！")
    mkdir(tkdev_path)
    console("创建成功！")
console(".tkdev文件夹位置在：" + tkdev_path)
console("开始检查工具文件夹是否创建好！")
tkdev_tools_path = tkdev_path + "\\tools"
if exists(tkdev_tools_path):
    console("检测到 tools 已经存在！")
else:
    console("未检测到 tools ，准备开始创建 tools 文件夹！")
    mkdir(tkdev_tools_path)
    console("创建成功！")
console("开始检查工具是否创建好...")

if is64():
    tkdev_winico_path = tkdev_tools_path + "\\Winico64.zip"
    tkdev_twapi_path = tkdev_tools_path + "\\twapi.zip"
else:
    tkdev_winico_path = tkdev_tools_path + "\\Winico32.zip"
    tkdev_twapi_path = tkdev_tools_path + "\\twapi.zip"

if exists(tkdev_winico_path):
    console("检测到已经安装好Winico！")
else:
    console("未检测到Winico！")
    console("准备开始安装...")
    if is64():
        install("https://tkdev-docs.netlify.app/_files/Winico64.zip", tkdev_winico_path)
    else:
        install("https://tkdev-docs.netlify.app/_files/Winico32.zip", tkdev_winico_path)
if exists(tkdev_twapi_path):
    console("检测到已经安装好twApi！")
else:
    console("未检测到twApi！")
    console("准备开始安装...")
    install("https://tkdev-docs.netlify.app/_files/twapi.zip", tkdev_twapi_path)

console("安装完成！")
console("初始化完毕！")
