from tkinter import *
from tkinter import ttk
from typing import Literal


class DevPreToolbox(Toplevel):
    def __init__(self, master: Tk, title: str = "ToolBox"):
        """
        在测试窗口时可以使用工具箱来调整窗口。

        :param master: 组件的父组件
        :param title: 工具箱的标题
        """
        super(DevPreToolbox, self).__init__(master=master)
        from tkdev import window_move, window_border
        from tkinter import ttk
        self.configure(background="#fcfcfc")
        self.geometry("355x450")
        self.title = Label(self, text=title, background="#fcfcfc")
        self.title.pack(fill=X, side=TOP)

        window_move(self.title, self)
        window_border(self)
        self.Title_Button = ttk.Button(self, text="修改标题", command=self.set_title)
        self.Title_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Topmost_Button = ttk.Button(self, text="置顶", command=self.set_topmost)
        self.Topmost_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.No_Topmost_Button = ttk.Button(self, text="取消置顶", command=self.set_no_topmost)
        self.No_Topmost_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Mica_Light_Button = ttk.Button(self, text="云母特效-浅色", command=self.mica_light)
        self.Mica_Light_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Mica_Dark_Button = ttk.Button(self, text="云母特效-深色", command=self.mica_dark)
        self.Mica_Dark_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Acrylic_Light_Button = ttk.Button(self, text="亚克力特效-浅色", command=self.acrylic_light)
        self.Acrylic_Light_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Acrylic_Dark_Button = ttk.Button(self, text="亚克力特效-深色", command=self.acrylic_dark)
        self.Acrylic_Dark_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Close_Me_Button = ttk.Button(self, text="关闭工具箱", command=self.destroy)
        self.Close_Me_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.Close_Button = ttk.Button(self, text="关闭窗口", command=self.master.destroy)
        self.Close_Button.pack(fill=X, side=TOP, padx=5, pady=5, ipady=5)
        self.master = master

    def set_title(self):
        """
        内置函数，用于设置窗口标题
        """
        from tkinter import simpledialog
        title = simpledialog.askstring("输入标题", "请设置窗口的标题")
        self.master.title(title)

    def set_topmost(self):
        """
        内置函数，用于置顶窗口
        """
        self.master.attributes("-topmost", True)

    def set_no_topmost(self):
        """
        内置函数，用于取消窗口置顶
        """
        self.master.attributes("-topmost", False)

    def mica_light(self):
        """
        内置函数，用于设置云母特效明亮主题
        """
        from tkdev import window_mica_light
        window_mica_light(self.master)
        self.master.configure(background="#ffffff")

    def mica_dark(self):
        """
        内置函数，用于设置云母特效暗黑主题
        """
        from tkdev import window_mica_dark
        window_mica_dark(self.master)
        self.master.configure(background="#000000")

    def acrylic_light(self):
        from tkdev import window_acrylic
        window_acrylic(self.master, False)
        self.master.configure(background="#ffffff")

    def acrylic_dark(self):
        from tkdev import window_acrylic
        window_acrylic(self.master, True)
        self.master.configure(background="#000000")

    def show(self):
        """
        内置函数，用于显示窗口。
        """
        self.mainloop()


if __name__ == '__main__':
    Window = Tk()
    Window.title("Hello")
    Toolbox = DevPreToolbox(Window)
    Window.mainloop()
