# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class ChartDataApiOperations(object):
    """ChartDataApiOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def get_chart_items(
            self, chart_id, version, custom_headers=None, raw=False, **operation_config):
        """Fetches all the items in the organization chart.

        <b>Please note</b> Only charts created via the API or by uploading a
        spreadsheet are supported in this version of the API.<br />
        Sample request:
        GET /api/v1/data/53bec490-1cdc-42f5-8983-e6efe66dc685.

        :param chart_id: Id of chart
        :type chart_id: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~teamorgchart.apilibrary.models.JsonChartItemViewModel]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_chart_items.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[JsonChartItemViewModel]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_chart_items.metadata = {'url': '/api/v{version}/data/{chartId}'}

    def create_chart_item(
            self, chart_id, model, version, custom_headers=None, raw=False, **operation_config):
        """Creates a single chart item in an organization chart.

        <b>Please note</b> Only charts created via the API or by uploading a
        spreadsheet are supported in this version of the API.<br />
        The data must contain a <b>Unqiue Id</b> and <b>Manager Id</b> other
        can be added as required for example <b>DisplayName</b> or <b>Email</b>
        Sample request:
        POST /api/v1/data/53bec490-1cdc-42f5-8983-e6efe66dc685/
        [{
        "UniqueId": "2",
        "ManagerId": "1",
        "DisplayName": "Mike Smith",
        "Title": "CTO"
        }].

        :param chart_id: Id of the chart in which the item will be created
        :type chart_id: str
        :param model: JSON model of the item to be created.
        :type model: object
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JsonChartItemViewModel or ClientRawResponse if raw=true
        :rtype: ~teamorgchart.apilibrary.models.JsonChartItemViewModel or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_chart_item.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(model, 'object')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 201:
            deserialized = self._deserialize('JsonChartItemViewModel', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_chart_item.metadata = {'url': '/api/v{version}/data/{chartId}'}

    def delete_chart_item(
            self, chart_id, unique_id, version, custom_headers=None, raw=False, **operation_config):
        """Delete a chart item from an organization chart.

        <b>Please note</b> Only charts created via the API or by uploading a
        spreadsheet are supported in this version of the API.<br />
        Sample request:
        DELETE
        /api/v1/data/53bec490-1cdc-42f5-8983-e6efe66dc685?uniqueId=111-222.

        :param chart_id: Id of chart that contains the item
        :type chart_id: str
        :param unique_id: Id of the item to remove from the chart
        :type unique_id: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_chart_item.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['uniqueId'] = self._serialize.query("unique_id", unique_id, 'str')

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 404]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_chart_item.metadata = {'url': '/api/v{version}/data/{chartId}'}

    def create_chart_items(
            self, chart_id, items, version, custom_headers=None, raw=False, **operation_config):
        """Uploads a list of chart items and creates them within the chart.

        <b>Please note</b> Only charts created via the API or by uploading a
        spreadsheet are supported in this version of the API.<br />
        Sample request:
        POST /api/v1/data/53bec490-1cdc-42f5-8983-e6efe66dc685/bulk
        [{
        "UniqueId": "2",
        "ManagerId": "1",
        "DisplayName": "Mike Smith",
        "Title": "CTO"
        },
        {
        "UniqueId": "3",
        "ManagerId": "1",
        "DisplayName": "Jane Doe",
        "Title": "CFO"
        }].

        :param chart_id: Id of the chart in the item will be created
        :type chart_id: str
        :param items: List of item objects
        :type items: list[object]
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~teamorgchart.apilibrary.models.JsonChartItemViewModel]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_chart_items.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(items, '[object]')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201, 400, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 201:
            deserialized = self._deserialize('[JsonChartItemViewModel]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_chart_items.metadata = {'url': '/api/v{version}/data/{chartId}/bulk'}

    def get_chart_item(
            self, chart_id, unique_id, version, custom_headers=None, raw=False, **operation_config):
        """Fetches a single chart item from the organization chart.

        <b>Please note</b> Only charts created via the API or by uploading a
        spreadsheet are supported in this version of the API.<br />
        Sample request:
        GET /api/v1/data/53bec490-1cdc-42f5-8983-e6efe66dc685?uniqueId=111-222.

        :param chart_id: Id of chart which the item belongs to
        :type chart_id: str
        :param unique_id: Id of the item to return
        :type unique_id: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: JsonChartItemViewModel or ClientRawResponse if raw=true
        :rtype: ~teamorgchart.apilibrary.models.JsonChartItemViewModel or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_chart_item.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['uniqueId'] = self._serialize.query("unique_id", unique_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('JsonChartItemViewModel', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_chart_item.metadata = {'url': '/api/v{version}/data/{chartId}/item'}

    def get_chart_view(
            self, chart_id, version, start_value=None, depth=None, custom_headers=None, raw=False, **operation_config):
        """Fetches chart data in a hierarchical view.

        <b>Please note</b> Only charts created via the API or by uploading a
        spreadsheet are supported in this version of the API.<br />
        Sample request:
        GET /api/v1/data/chartview/53bec490-1cdc-42f5-8983-e6efe66dc685.

        :param chart_id: Id of chart
        :type chart_id: str
        :param version:
        :type version: str
        :param start_value: The unique Id to begin fetching from
        :type start_value: str
        :param depth: The number of levels of the organization chart to
         process
        :type depth: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ChartDataView or ClientRawResponse if raw=true
        :rtype: ~teamorgchart.apilibrary.models.ChartDataView or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_chart_view.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if start_value is not None:
            query_parameters['startValue'] = self._serialize.query("start_value", start_value, 'str')
        if depth is not None:
            query_parameters['depth'] = self._serialize.query("depth", depth, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ChartDataView', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_chart_view.metadata = {'url': '/api/v{version}/data/chartview/{chartId}'}
