# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class PositionsApiOperations(object):
    """PositionsApiOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def get_chart_positions(
            self, chart_id, version, custom_headers=None, raw=False, **operation_config):
        """Returns a list of the temporary, vacant or department chart positions
        defined for the chart.

        Sample request:
        GET /api/v1/positions/53bec490-1cdc-42f5-8983-e6efe66dc685.

        :param chart_id: ID of the chart definition
        :type chart_id: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~teamorgchart.apilibrary.models.ChartPosition] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_chart_positions.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ChartPosition]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_chart_positions.metadata = {'url': '/api/v{version}/positions/{chartId}'}

    def create_chart_position(
            self, chart_id, model, version, custom_headers=None, raw=False, **operation_config):
        """Creates a new or updates an existing temporary, vacant or department
        positions in the chart.

        Sample request:
        POST /api/v1/positions/53bec490-1cdc-42f5-8983-e6efe66dc685
        [{
        "Id": 0,
        "Name": "Harry Potter",
        "ManagerId": "xxx-eee-333-sss-",
        "FriendlyManagerId": "string",
        "Position": "string",
        "IsTempPosition": true,
        "ExpireDate": "2020-01-29T09:13:53.895Z",
        "UniqueId": "abc123",
        "ViewItem": "",
        "PictureUrl": "",
        "IsDepartment": false,
        "DepartmentTitle": "",
        "DepartmentText": ""
        }].

        :param chart_id: ID of the chart definition
        :type chart_id: str
        :param model: Position model
        :type model: ~teamorgchart.apilibrary.models.ChartPosition
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ChartPosition or ClientRawResponse if raw=true
        :rtype: ~teamorgchart.apilibrary.models.ChartPosition or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_chart_position.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(model, 'ChartPosition')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201, 400]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 201:
            deserialized = self._deserialize('ChartPosition', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_chart_position.metadata = {'url': '/api/v{version}/positions/{chartId}'}

    def delete_chart_position(
            self, chart_id, unique_id, version, custom_headers=None, raw=False, **operation_config):
        """Removes a temporary, vacant or department position from the chart and
        returns a list of the remaining positions.

        Sample request:
        DELETE
        /api/v1/positions/53bec490-1cdc-42f5-8983-e6efe66dc685?uniqueId=1234.

        :param chart_id: ID of the chart definition
        :type chart_id: str
        :param unique_id: ID of the position
        :type unique_id: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~teamorgchart.apilibrary.models.ChartPosition] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_chart_position.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['uniqueId'] = self._serialize.query("unique_id", unique_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ChartPosition]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_chart_position.metadata = {'url': '/api/v{version}/positions/{chartId}'}

    def get_chart_position_by_id(
            self, chart_id, unique_id, version, custom_headers=None, raw=False, **operation_config):
        """Returns a single temporary, vacant or department position by ID.

        Sample request:
        GET
        /api/v1/positions/53bec490-1cdc-42f5-8983-e6efe66dc685?uniqueId=1234.

        :param chart_id: ID of the chart definition
        :type chart_id: str
        :param unique_id: ID of the position
        :type unique_id: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ChartPosition or ClientRawResponse if raw=true
        :rtype: ~teamorgchart.apilibrary.models.ChartPosition or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_chart_position_by_id.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['uniqueId'] = self._serialize.query("unique_id", unique_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ChartPosition', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_chart_position_by_id.metadata = {'url': '/api/v{version}/positions/{chartId}/position'}
