# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class RemappingsApiOperations(object):
    """RemappingsApiOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def get_remappings(
            self, chart_id, version, custom_headers=None, raw=False, **operation_config):
        """Returns a list of the temporary, vacant or department chart positions
        defined for the chart.

        Sample request:
        GET /api/v1/remappings/53bec490-1cdc-42f5-8983-e6efe66dc685.

        :param chart_id: ID of the chart definition
        :type chart_id: str
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype: list[~teamorgchart.apilibrary.models.Remapping] or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_remappings.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[Remapping]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_remappings.metadata = {'url': '/api/v{version}/remappings/{chartId}'}

    def add_remapping(
            self, chart_id, model, version, custom_headers=None, raw=False, **operation_config):
        """Creates a new or updates an existing remapping in the chart.

        Sample request:
        POST /api/v1/remappings/53bec490-1cdc-42f5-8983-e6efe66dc685
        [{
        "Id": 0,
        "UniqueId": "string",
        "FriendlyUniqueId": "string",
        "ManagerId": "string",
        "FriendlyManagerId": "string",
        "MappedId": "string",
        "FriendlyMappedId": "string"
        }].

        :param chart_id: ID of the chart definition
        :type chart_id: str
        :param model: Remapping model
        :type model: ~teamorgchart.apilibrary.models.Remapping
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: Remapping or ClientRawResponse if raw=true
        :rtype: ~teamorgchart.apilibrary.models.Remapping or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.add_remapping.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(model, 'Remapping')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201, 400, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 201:
            deserialized = self._deserialize('Remapping', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    add_remapping.metadata = {'url': '/api/v{version}/remappings/{chartId}'}

    def delete_remapping(
            self, chart_id, remapping_id, version, custom_headers=None, raw=False, **operation_config):
        """Removes a remapping from the chart.

        Sample request:
        DELETE /api/v1/remappings/53bec490-1cdc-42f5-8983-e6efe66dc685/123456.

        :param chart_id: ID of the chart definition
        :type chart_id: str
        :param remapping_id: ID of the mapping
        :type remapping_id: int
        :param version:
        :type version: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_remapping.metadata['url']
        path_format_arguments = {
            'chartId': self._serialize.url("chart_id", chart_id, 'str'),
            'remappingId': self._serialize.url("remapping_id", remapping_id, 'int'),
            'version': self._serialize.url("version", version, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 404]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
    delete_remapping.metadata = {'url': '/api/v{version}/remappings/{chartId}/{remappingId}'}
