# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.exceptions import HttpOperationError
from .operations.chart_data_api_operations import ChartDataApiOperations
from .operations.charts_api_operations import ChartsApiOperations
from .operations.positions_api_operations import PositionsApiOperations
from .operations.remappings_api_operations import RemappingsApiOperations
from . import models


class TeamOrgChartApiConfiguration(Configuration):
    """Configuration for TeamOrgChartApi
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        if not base_url:
            base_url = 'https://teamorgchart.com'

        super(TeamOrgChartApiConfiguration, self).__init__(base_url)

        self.add_user_agent('teamorgchartapi/{}'.format(VERSION))


class TeamOrgChartApi(SDKClient):
    """TeamOrgChartApi

    :ivar config: Configuration for client.
    :vartype config: TeamOrgChartApiConfiguration

    :ivar chart_data_api: ChartDataApi operations
    :vartype chart_data_api: teamorgchart.apilibrary.operations.ChartDataApiOperations
    :ivar charts_api: ChartsApi operations
    :vartype charts_api: teamorgchart.apilibrary.operations.ChartsApiOperations
    :ivar positions_api: PositionsApi operations
    :vartype positions_api: teamorgchart.apilibrary.operations.PositionsApiOperations
    :ivar remappings_api: RemappingsApi operations
    :vartype remappings_api: teamorgchart.apilibrary.operations.RemappingsApiOperations

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        self.config = TeamOrgChartApiConfiguration(base_url)
        super(TeamOrgChartApi, self).__init__(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v1'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.chart_data_api = ChartDataApiOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.charts_api = ChartsApiOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.positions_api = PositionsApiOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.remappings_api = RemappingsApiOperations(
            self._client, self.config, self._serialize, self._deserialize)
