from pydantic import Field
from typing import Any, TypeAlias
from ...._schemas import ResponseBase


class TrialInfo(ResponseBase):
    can_have_trial: bool = Field(description="CanHaveInitialTrial is true if neither the organization nor the owner has never had a trial before")
    last_pricing_plan_id: int | None = Field(default=None)
    next_payment_date: str | None = Field(default=None)
    trial: bool = Field(description="Whether the organization's subscription is currently on trial")
    trial_available: bool = Field(description="When a trial is available for this organization Deprecated: TrialAvailable - use CanHaveInitialTrial instead. Retained for front-end compatibility.")
    trial_end_date: str | None = Field(default=None)
    trial_plan_id: int | None = Field(default=None)

class Organization(ResponseBase):
    admin: bool = Field(description="Whether the requester is an admin of the organization")
    at: str = Field(description="Organization's last modification date")
    created_at: str = Field(description="Organization's creation date")
    id: int = Field(description="Organization ID")
    is_multi_workspace_enabled: bool = Field(description="Is true when the organization option is_multi_workspace_enabled is set")
    is_unified: bool
    max_data_retention_days: Any | None = Field(default=None, description="How far back free workspaces in this org can access data.")
    max_workspaces: int = Field(description="Maximum number of workspaces allowed for the organization")
    name: str = Field(description="Organization Name")
    owner: bool = Field(description="Whether the requester is a the owner of the organization")
    permissions: list[str] = Field(description="Array of string")
    pricing_plan_enterprise: bool = Field(description="The subscription plan is an enterprise plan")
    pricing_plan_id: int = Field(description="Organization plan ID")
    pricing_plan_name: str = Field(description="The subscription plan name the org is currently on. Free or any plan name coming from payment provider")
    suspended_at: str = Field(description="Whether the organization is currently suspended")
    trial_info: TrialInfo | None = Field(default=None, description="Trial information")
    user_count: int = Field(description="Number of organization users")


GetOrganizationsResponse: TypeAlias = list[Organization]
