from ..._resource import SyncAPIResourceBase, AsyncAPIResourceBase
from .schemas import PostOrganizationRequest, PostOrganizationResponse

class Organizations(SyncAPIResourceBase):
    def post(self, data: PostOrganizationRequest) -> PostOrganizationResponse:
        return self._client.post(path="organizations", options={"body": data}, ResponseT=PostOrganizationResponse)

class AsyncOrganizations(AsyncAPIResourceBase):
    async def post(self, data: PostOrganizationRequest) -> PostOrganizationResponse:
        return await self._client.post(path="organizations", options={"body": data}, ResponseT=PostOrganizationResponse)