# generated by datamodel-codegen:
#   filename:  openapi.TollBit.Apis.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List

from pydantic import AnyUrl, BaseModel


class Availability(BaseModel):
    discoverable: bool
    ready_to_license: bool


class ContentMetadata(BaseModel):
    title: str | None = None
    description: str | None = None
    imageUrl: str | None = None
    author: str | None = None
    published: str | None = None
    modified: str | None = None


class CreateAOSAccessTokenRequest(BaseModel):
    url: AnyUrl
    userAgent: str


class CreateAOSAccessTokenResponse(BaseModel):
    token: str


class CreateCrawlAccessTokenRequest(BaseModel):
    url: AnyUrl
    userAgent: str


class CreateCrawlAccessTokenResponse(BaseModel):
    token: str


class Format(Enum):
    html = 'html'
    markdown = 'markdown'


class CreateSubdomainAccessTokenRequest(BaseModel):
    url: AnyUrl
    userAgent: str
    maxPriceMicros: int
    currency: str
    licenseType: str
    licenseCuid: str
    format: Format


class CreateSubdomainAccessTokenResponse(BaseModel):
    token: str


class Error(BaseModel):
    pass


class PageContent(BaseModel):
    header: str
    body: str
    footer: str


class ProblemJSON(BaseModel):
    type: str
    title: str
    status: int
    detail: str | None = None
    instance: str | None = None


class PropertyPage(BaseModel):
    propertyId: str
    pageUrl: str
    lastMod: datetime | None = None


class Publisher(BaseModel):
    domain: str
    name: str


class RateLicensePermission(BaseModel):
    name: str


class RateLicenseResponse(BaseModel):
    id: str
    licenseType: str
    licensePath: str
    permissions: List[RateLicensePermission]
    validUntil: datetime


class RatePrice(BaseModel):
    priceMicros: int
    currency: str


class SearchResult(BaseModel):
    title: str
    url: str
    published_date: str
    publisher: Publisher
    availability: Availability


class Type(Enum):
    http = 'http'


class Scheme(Enum):
    Bearer = 'Bearer'


class SubdomainAccessToken(BaseModel):
    type: Type
    scheme: Scheme


class CatalogResponse(BaseModel):
    pageToken: str | None = None
    pages: List[PropertyPage]


class ContentRate(BaseModel):
    price: RatePrice
    license: RateLicenseResponse


class DeveloperRateResponse(BaseModel):
    price: RatePrice
    license: RateLicenseResponse


class GetContentResponse(BaseModel):
    content: PageContent
    metadata: ContentMetadata
    rate: ContentRate | None = None
