# generated by datamodel-codegen:
#   filename:  openapi.TollBit.Apis.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List

from pydantic import AnyUrl, Field
from tollbit._apis.models.api_base import TollbitBaseModel


class Availability(TollbitBaseModel):
    discoverable: bool
    ready_to_license: bool = Field(..., alias='readyToLicense')


class ContentMetadata(TollbitBaseModel):
    title: str | None = None
    description: str | None = None
    image_url: str | None = Field(None, alias='imageUrl')
    author: str | None = None
    published: str | None = None
    modified: str | None = None


class CreateAOSAccessTokenRequest(TollbitBaseModel):
    url: AnyUrl
    user_agent: str = Field(..., alias='userAgent')


class CreateAOSAccessTokenResponse(TollbitBaseModel):
    token: str


class CreateCrawlAccessTokenRequest(TollbitBaseModel):
    url: AnyUrl
    user_agent: str = Field(..., alias='userAgent')


class CreateCrawlAccessTokenResponse(TollbitBaseModel):
    token: str


class Format(Enum):
    html = 'html'
    markdown = 'markdown'


class CreateSubdomainAccessTokenRequest(TollbitBaseModel):
    url: AnyUrl
    user_agent: str = Field(..., alias='userAgent')
    max_price_micros: int = Field(..., alias='maxPriceMicros')
    currency: str
    license_type: str = Field(..., alias='licenseType')
    license_cuid: str = Field(..., alias='licenseCuid')
    format: Format | None = None


class CreateSubdomainAccessTokenResponse(TollbitBaseModel):
    token: str


class Error(TollbitBaseModel):
    pass


class PageContent(TollbitBaseModel):
    header: str
    body: str
    footer: str


class ProblemJSON(TollbitBaseModel):
    type: str
    title: str
    status: int
    detail: str | None = None
    instance: str | None = None


class PropertyPage(TollbitBaseModel):
    property_id: str = Field(..., alias='propertyId')
    page_url: str = Field(..., alias='pageUrl')
    last_mod: datetime | None = Field(None, alias='lastMod')


class Publisher(TollbitBaseModel):
    domain: str
    name: str


class RateLicensePermission(TollbitBaseModel):
    name: str


class RateLicenseResponse(TollbitBaseModel):
    id: str
    license_type: str = Field(..., alias='licenseType')
    license_path: str = Field(..., alias='licensePath')
    permissions: List[RateLicensePermission]


class RatePrice(TollbitBaseModel):
    price_micros: int = Field(..., alias='priceMicros')
    currency: str


class SearchResult(TollbitBaseModel):
    title: str
    url: str
    published_date: str = Field(..., alias='publishedDate')
    publisher: Publisher
    availability: Availability


class SelfReportLicensePermission(TollbitBaseModel):
    name: str


class SelfReportUsage(TollbitBaseModel):
    url: AnyUrl
    times_used: int = Field(..., alias='timesUsed')
    license_permissions: List[SelfReportLicensePermission] = Field(..., alias='licensePermissions')
    license_id: str | None = Field(None, alias='licenseId')
    license_type: str = Field(..., alias='licenseType')
    metadata: Dict[str, Any] | None = None


class SelfReportUsageReceipt(TollbitBaseModel):
    url: AnyUrl
    per_unit_price_micros: int = Field(..., alias='perUnitPriceMicros')
    total_use_price_micros: int = Field(..., alias='totalUsePriceMicros')
    currency: str
    license: RateLicenseResponse


class Type(Enum):
    http = 'http'


class Scheme(Enum):
    bearer = 'Bearer'


class SubdomainAccessToken(TollbitBaseModel):
    type: Type
    scheme: Scheme


class CatalogResponse(TollbitBaseModel):
    page_token: str | None = Field(None, alias='pageToken')
    pages: List[PropertyPage]


class ContentRate(TollbitBaseModel):
    price: RatePrice
    license: RateLicenseResponse


class DeveloperRateResponse(TollbitBaseModel):
    price: RatePrice
    license: RateLicenseResponse


class GetContentResponse(TollbitBaseModel):
    content: PageContent
    metadata: ContentMetadata
    rate: ContentRate | None = None


class PagedSearchResultResponse(TollbitBaseModel):
    next_token: str = Field(..., alias='nextToken')
    items: List[SearchResult]


class SelfReportContentUsageRequest(TollbitBaseModel):
    idempotency_id: str = Field(..., alias='idempotencyId')
    usage: List[SelfReportUsage]


class SelfReportContentUsageResponse(TollbitBaseModel):
    receipts: List[SelfReportUsageReceipt]
