# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.1.1] - 2025-10-27

### Added
- Comprehensive README documentation with installation guide, usage examples, and API reference
- Reference to original TypeScript toon project (v0.3.1) in documentation
- MIT LICENSE file

### Changed
- Improved code formatting with consistent line breaks in function definitions and exception classes
- Updated encoder to output inline arrays on the same line as the header for better readability
- Enhanced visual presentation of TOON output format

### Fixed
- Reduced visual clutter in array output formatting

## [0.1.0] - 2025-10-27

### Added
- Initial release of TOON Python library
- Complete Python implementation of Token-Oriented Object Notation encoding
- Core encoding functionality with 30-60% token reduction compared to JSON
- Support for Python-specific types (datetime, Decimal, UUID, bytes)
- Flexible formatting options with configurable indentation, delimiters, and length markers
- Smart array optimization (inline, tabular, and list formats)
- Comprehensive type normalization for JSON compatibility
- Full test suite with unit tests, integration tests, and property-based testing
- Development tooling setup (ruff, black, mypy, pytest, hypothesis)
- Python 3.10+ support with type hints throughout
- Error handling for circular references and dataset size limits
- Pure Python implementation with no runtime dependencies

### Features
- **Token Efficiency**: Achieves 30-60% reduction compared to JSON
- **LLM-Friendly**: Explicit lengths and field lists for model validation
- **Minimal Syntax**: Removes redundant punctuation while maintaining readability
- **Pythonic API**: Simple, intuitive interface following Python conventions
- **Type Support**: Automatic normalization of Python types to JSON-compatible representations
- **Array Optimization**: Intelligent encoding strategy based on array content
- **Configuration**: Customizable formatting options for different use cases