"""
pytest configuration and fixtures for toon_python tests.
"""


import pytest

from src.toon_python.constants import Delimiter, EncodeOptions


@pytest.fixture
def basic_encode_options():
    """Basic encoding options for testing."""
    return EncodeOptions()


@pytest.fixture
def tab_encode_options():
    """Tab-delimited encoding options for testing."""
    return EncodeOptions(delimiter=Delimiter.TAB, indent=4)


@pytest.fixture
def sample_data():
    """Sample data structure for testing."""
    return {
        "name": "Alice",
        "age": 30,
        "active": True,
        "tags": ["admin", "ops", "dev"],
        "profile": {
            "email": "alice@example.com",
            "settings": {
                "theme": "dark",
                "notifications": False
            }
        }
    }


@pytest.fixture
def array_data():
    """Array data for testing optimization strategies."""
    return {
        "primitives": [1, 2, 3, 4, 5],
        "mixed": ["a", 1, True, None],
        "uniform_objects": [
            {"sku": "A1", "qty": 2, "price": 9.99},
            {"sku": "B2", "qty": 1, "price": 14.5}
        ],
        "nested": [[1, 2], [3, 4]]
    }
