from http import HTTPStatus
from typing import Any, cast

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.command_type import CommandType
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    device_id: int | Unset = UNSET,
    protocol: str | Unset = UNSET,
    text_channel: bool | Unset = UNSET,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    params["deviceId"] = device_id

    params["protocol"] = protocol

    params["textChannel"] = text_channel

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": "/commands/types",
        "params": params,
    }

    return _kwargs


def _parse_response(
    *, client: AuthenticatedClient | Client, response: httpx.Response
) -> Any | list[CommandType] | None:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = CommandType.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200

    if response.status_code == 400:
        response_400 = cast(Any, None)
        return response_400

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: AuthenticatedClient | Client, response: httpx.Response
) -> Response[Any | list[CommandType]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient | Client,
    device_id: int | Unset = UNSET,
    protocol: str | Unset = UNSET,
    text_channel: bool | Unset = UNSET,
) -> Response[Any | list[CommandType]]:
    """Fetch a list of available Commands for the Device or all possible Commands if Device ommited

    Args:
        device_id (int | Unset):
        protocol (str | Unset):
        text_channel (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Any | list[CommandType]]
    """

    kwargs = _get_kwargs(
        device_id=device_id,
        protocol=protocol,
        text_channel=text_channel,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient | Client,
    device_id: int | Unset = UNSET,
    protocol: str | Unset = UNSET,
    text_channel: bool | Unset = UNSET,
) -> Any | list[CommandType] | None:
    """Fetch a list of available Commands for the Device or all possible Commands if Device ommited

    Args:
        device_id (int | Unset):
        protocol (str | Unset):
        text_channel (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Any | list[CommandType]
    """

    return sync_detailed(
        client=client,
        device_id=device_id,
        protocol=protocol,
        text_channel=text_channel,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient | Client,
    device_id: int | Unset = UNSET,
    protocol: str | Unset = UNSET,
    text_channel: bool | Unset = UNSET,
) -> Response[Any | list[CommandType]]:
    """Fetch a list of available Commands for the Device or all possible Commands if Device ommited

    Args:
        device_id (int | Unset):
        protocol (str | Unset):
        text_channel (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Any | list[CommandType]]
    """

    kwargs = _get_kwargs(
        device_id=device_id,
        protocol=protocol,
        text_channel=text_channel,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient | Client,
    device_id: int | Unset = UNSET,
    protocol: str | Unset = UNSET,
    text_channel: bool | Unset = UNSET,
) -> Any | list[CommandType] | None:
    """Fetch a list of available Commands for the Device or all possible Commands if Device ommited

    Args:
        device_id (int | Unset):
        protocol (str | Unset):
        text_channel (bool | Unset):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Any | list[CommandType]
    """

    return (
        await asyncio_detailed(
            client=client,
            device_id=device_id,
            protocol=protocol,
            text_channel=text_channel,
        )
    ).parsed
