# TrainLoop CLI

The TrainLoop CLI is a lightweight command‑line tool for managing data collection, evaluation, and studio workflows in your TrainLoop projects.

---

## 🔧 Installation

You can install the latest released version from PyPI:

```bash
pip install trainloop-cli

# then run it via trainloop
trainloop --help
```
Or via pipx/uvx (recommended):

```bash
pipx run trainloop-cli --help
uvx run trainloop-cli --help
```

Or, if you’re developing locally from your monorepo root:
```bash
poetry install
poetry run trainloop --help
```

⸻

🚀 Quickstart

Initialize a new evaluation workspace:
```bash
trainloop init
```

Run an evaluation using your configured LLM judge:
```bash
trainloop eval
```

Launch the interactive “studio” UI in your browser:
```bash
trainloop studio
# then open http://localhost:8080
```

⸻

📖 Commands

Command	Description
`trainloop init` - Scaffold a new TrainLoop evaluation directory
`trainloop eval` - Run evaluations/tests against your prompts & responses
`trainloop studio` - Start the web‑based studio for interactive data collection
`trainloop --help` - Show global flags and help for all commands

For full details on each command and its flags:

```bash
trainloop <command> --help
# Or via pipx/uvx
pipx run trainloop-cli <command> --help
uvx run trainloop-cli <command> --help
```

⸻

🤝 Contributing
1. Fork the repo
2. Create a feature branch: `git checkout -b feat/my‑awesome‑feature`
3. Install dev‑deps: `poetry install`
4. Run tests: `poetry run pytest`
5. Submit a pull request

⸻

📄 License

MIT © 2025 TrainLoop