# Transformplot 3D
Transformplot 3D is a small library with useful commands that help visualize matrix transformations  with `matplotlib` plots. These matrices are from the `transformations` package.

It consists of only two main modules `vectors` and `quiver`. `vectors` offers some basic commands of reshaping a vector or a matrix, while `quiver` offers methods of converting lists of vectors and matrices into tuples ready to be input in matplotlib `quiver()` method. Note that matplotlib is not actually required for the methods in this package, but is needed to take advantage of it.

All the methods in the package are shown below. Because this is a small package, I don't think there's a for documentation yet.

[Repository on Github](https://github.com/janSani/transformplot3d)

## Methods
Because this is a small package, I don't think there's a for documentation yet. Thus, all methods are shown below

`extend_vector(vector: list)`
- Returns the input list with a 1 appended at the end.

`reduce_vector(vector: list)`
- Returns the input list without the last element.

`reduced_and_extended(vector)`
- Returns the input vector and a reduced version of it (without the last element)

`extend_matrix(matrix: list)`
- Returns an extension of the input with the form `[[matrix, zeros],[zeros,1]]`. 

`reduce_matrix(matrix: list)`
- Returns the input matrix without the last row and last column.

`one_vector_many_systems(vector, matrices: list)`
- Takes a single input vector and returns the position and direction it would have if it was in the coordinate systems generated by the input transformation matrices.

`many_vectors_one_system(vectors: list, matrix: list)`
- Takes a each input vector and returns the position and direction they would have if it was in the coordinate system generated by the input transformation matrix.

`many_vectors_many_systems(vectors: list, matrices: list)`
- Takes a each input vector and returns the position and direction they would have if it was in the coordinate system generated by the corresponding input matrix. Input vector list and input matrix list must be the same size.

`draw_axes_from_matrices(matrices: list, orderByAxes = False, separateXYZ = False)`
- This method returns a 6-tuple of lists, the first 3 indicate the origin of the coordinate systems, the last 3 indicate the direction of the axes. Basis vectors of the coordinate systems are generated by the input transformation matrices.