# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...errors.not_found_error import NotFoundError
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.extract_response import ExtractResponse
from ...types.http_validation_error import HttpValidationError
from ...types.log_level_enum import LogLevelEnum
from ...types.parse_strategy import ParseStrategy

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AssetsExtractClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def extract_files(
        self,
        *,
        asset_ids: typing.Optional[typing.List[str]] = OMIT,
        proj_name: typing.Optional[str] = OMIT,
        parse_strategy: typing.Optional[ParseStrategy] = OMIT,
        callback_url: typing.Optional[str] = OMIT,
        auth_key: typing.Optional[str] = OMIT,
        log_level: typing.Optional[LogLevelEnum] = OMIT,
    ) -> ExtractResponse:
        """
        Args:
        asset_ids: The list of asset ids to extract. If the asset_ids are provided, the proj_name will be ignored.
        proj_name: When defined, the extraction will be applied to all assets within the project. If the proj_name is provided, the asset_ids will be ignored. This will override any previous extractions set for assets.
        parse_strategy: The parsing strategy to be used for the PDF file. Can be "optimized", "transformer" or "ocr". The default is "optimized".
        callback_url: The Callback URL to which the response will be sent after the files are processed.
        auth_key: The Authorization key to be used for the callback URL.
        log_level: Logs for the file upload. Can be "verbose" or "concise". The default is "concise".

        Parameters:
            - asset_ids: typing.Optional[typing.List[str]].

            - proj_name: typing.Optional[str].

            - parse_strategy: typing.Optional[ParseStrategy].

            - callback_url: typing.Optional[str].

            - auth_key: typing.Optional[str].

            - log_level: typing.Optional[LogLevelEnum].
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.assets_extract.extract_files()
        """
        _request: typing.Dict[str, typing.Any] = {}
        if asset_ids is not OMIT:
            _request["asset_ids"] = asset_ids
        if proj_name is not OMIT:
            _request["proj_name"] = proj_name
        if parse_strategy is not OMIT:
            _request["parse_strategy"] = parse_strategy.value
        if callback_url is not OMIT:
            _request["callback_url"] = callback_url
        if auth_key is not OMIT:
            _request["auth_key"] = auth_key
        if log_level is not OMIT:
            _request["log_level"] = log_level.value
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/assets/extract"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ExtractResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncAssetsExtractClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def extract_files(
        self,
        *,
        asset_ids: typing.Optional[typing.List[str]] = OMIT,
        proj_name: typing.Optional[str] = OMIT,
        parse_strategy: typing.Optional[ParseStrategy] = OMIT,
        callback_url: typing.Optional[str] = OMIT,
        auth_key: typing.Optional[str] = OMIT,
        log_level: typing.Optional[LogLevelEnum] = OMIT,
    ) -> ExtractResponse:
        """
        Args:
        asset_ids: The list of asset ids to extract. If the asset_ids are provided, the proj_name will be ignored.
        proj_name: When defined, the extraction will be applied to all assets within the project. If the proj_name is provided, the asset_ids will be ignored. This will override any previous extractions set for assets.
        parse_strategy: The parsing strategy to be used for the PDF file. Can be "optimized", "transformer" or "ocr". The default is "optimized".
        callback_url: The Callback URL to which the response will be sent after the files are processed.
        auth_key: The Authorization key to be used for the callback URL.
        log_level: Logs for the file upload. Can be "verbose" or "concise". The default is "concise".

        Parameters:
            - asset_ids: typing.Optional[typing.List[str]].

            - proj_name: typing.Optional[str].

            - parse_strategy: typing.Optional[ParseStrategy].

            - callback_url: typing.Optional[str].

            - auth_key: typing.Optional[str].

            - log_level: typing.Optional[LogLevelEnum].
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.assets_extract.extract_files()
        """
        _request: typing.Dict[str, typing.Any] = {}
        if asset_ids is not OMIT:
            _request["asset_ids"] = asset_ids
        if proj_name is not OMIT:
            _request["proj_name"] = proj_name
        if parse_strategy is not OMIT:
            _request["parse_strategy"] = parse_strategy.value
        if callback_url is not OMIT:
            _request["callback_url"] = callback_url
        if auth_key is not OMIT:
            _request["auth_key"] = auth_key
        if log_level is not OMIT:
            _request["log_level"] = log_level.value
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/assets/extract"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ExtractResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
