# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.not_found_error import NotFoundError
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.get_validations_response import GetValidationsResponse
from ...types.http_validation_error import HttpValidationError
from ...types.override_validation_results_response import OverrideValidationResultsResponse
from ...types.validation_delete_response import ValidationDeleteResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ValidationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_validations(
        self, transform_id: str, *, result_id: typing.Optional[str] = None, precedence: typing.Optional[bool] = None
    ) -> GetValidationsResponse:
        """
        Retrieve the validation results for a given transform_id.

        Args:
        transform_id (str): The ID of the transformation.

        Returns:
        dict: A dictionary containing the validation results.

        Parameters:
            - transform_id: str.

            - result_id: typing.Optional[str]. The ID of the result to get the validation for (optional)

            - precedence: typing.Optional[bool].
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.validation.get_validations(
            transform_id="transform_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/validations"
            ),
            params=remove_none_from_dict({"result_id": result_id, "precedence": precedence}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetValidationsResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_manual_results(self, validation_id: str) -> ValidationDeleteResponse:
        """
        Parameters:
            - validation_id: str.
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.validation.delete_manual_results(
            validation_id="validation_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/validations/{validation_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ValidationDeleteResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def override_validation_results(
        self, validation_id: str, *, result: typing.Optional[bool] = None
    ) -> OverrideValidationResultsResponse:
        """
        Parameters:
            - validation_id: str.

            - result: typing.Optional[bool].
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.validation.override_validation_results(
            validation_id="validation_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/validations/{validation_id}"
            ),
            params=remove_none_from_dict({"result": result}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OverrideValidationResultsResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncValidationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_validations(
        self, transform_id: str, *, result_id: typing.Optional[str] = None, precedence: typing.Optional[bool] = None
    ) -> GetValidationsResponse:
        """
        Retrieve the validation results for a given transform_id.

        Args:
        transform_id (str): The ID of the transformation.

        Returns:
        dict: A dictionary containing the validation results.

        Parameters:
            - transform_id: str.

            - result_id: typing.Optional[str]. The ID of the result to get the validation for (optional)

            - precedence: typing.Optional[bool].
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.validation.get_validations(
            transform_id="transform_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/validations"
            ),
            params=remove_none_from_dict({"result_id": result_id, "precedence": precedence}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetValidationsResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_manual_results(self, validation_id: str) -> ValidationDeleteResponse:
        """
        Parameters:
            - validation_id: str.
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.validation.delete_manual_results(
            validation_id="validation_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/validations/{validation_id}"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ValidationDeleteResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def override_validation_results(
        self, validation_id: str, *, result: typing.Optional[bool] = None
    ) -> OverrideValidationResultsResponse:
        """
        Parameters:
            - validation_id: str.

            - result: typing.Optional[bool].
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.validation.override_validation_results(
            validation_id="validation_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/validations/{validation_id}"
            ),
            params=remove_none_from_dict({"result": result}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(OverrideValidationResultsResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
