# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ValidationModel(pydantic.BaseModel):
    """
    Represents a validation model.

    Attributes:
    id (str): The ID of the validation.
    result_id (str): The ID of the result.
    validation_name (str): The name of the validation.
    validation_columns (List[str]): The list of columns to be validated.
    validation_rule (str): The validation rule.
    result (bool): The result of the validation.
    transform_id (str): The ID of the transformation.
    overridden_by (str): The ID of the validation that overrides this validation.
    validation_param_id (str): The ID of the validation parameter.
    deleted_at (datetime): The timestamp when the validation was deleted.
    created_at (datetime): The timestamp when the validation was created.
    """

    id: typing.Optional[str]
    result_id: typing.Optional[str]
    validation_name: typing.Optional[str]
    validation_columns: typing.Optional[typing.List[str]]
    validation_rule: typing.Optional[str]
    result: typing.Optional[bool]
    transform_id: str
    overridden_by: typing.Optional[str]
    validation_param_id: typing.Optional[str]
    deleted_at: typing.Optional[dt.datetime]
    created_at: dt.datetime

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
