# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.not_found_error import NotFoundError
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.create_autoschema_response import CreateAutoschemaResponse
from ...types.delete_transform_response import DeleteTransformResponse
from ...types.get_transform_reference_response import GetTransformReferenceResponse
from ...types.get_transform_results_response import GetTransformResultsResponse
from ...types.http_validation_error import HttpValidationError
from ...types.initiate_transform_response import InitiateTransformResponse
from ...types.order_by_enum import OrderByEnum
from ...types.re_run_transform_response import ReRunTransformResponse
from ...types.sort_order_enum import SortOrderEnum
from ...types.transform_params import TransformParams
from ...types.transform_preview_response import TransformPreviewResponse
from ...types.update_transform_result_response import UpdateTransformResultResponse
from ...types.validation_params import ValidationParams
from .types.get_transforms_v_1_transforms_get_response import GetTransformsV1TransformsGetResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TransformsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_transforms(
        self,
        *,
        transform_ids: typing.Optional[typing.Union[str, typing.List[str]]] = None,
        proj_names: typing.Optional[typing.Union[str, typing.List[str]]] = None,
        include_params: typing.Optional[bool] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        order_by: typing.Optional[OrderByEnum] = None,
        order: typing.Optional[SortOrderEnum] = None,
    ) -> GetTransformsV1TransformsGetResponse:
        """
        Retrieve all transformation associated with you.

        Parameters:

        - limit (int): The number of transformations to retrieve.
        - offset (int): The offset to start retrieving transformations from.
        - order_by (str): The column to order the transformations by.
        - order (str): The order to sort the transformations by.
        - transform_ids (list, optional): The IDs of the transformations to retrieve.
        - proj_names (list, optional): The names of the projects to retrieve transformations from.
        - include_params (bool, optional): Include metadata in the response such as the transform_params and validation_params. Defaults to false.

        Returns:

        - dict: A dict containing all the transformations associated with you.

        Parameters:
            - transform_ids: typing.Optional[typing.Union[str, typing.List[str]]]. List of transform IDs to retrieve.

            - proj_names: typing.Optional[typing.Union[str, typing.List[str]]]. List of project names to retrieve transformations from.

            - include_params: typing.Optional[bool]. Boolean flag to include params in the response such as the transform_params and validation_params.

            - limit: typing.Optional[int].

            - offset: typing.Optional[int].

            - order_by: typing.Optional[OrderByEnum].

            - order: typing.Optional[SortOrderEnum].
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/transforms"),
            params=remove_none_from_dict(
                {
                    "transform_ids": transform_ids,
                    "proj_names": proj_names,
                    "include_params": include_params,
                    "limit": limit,
                    "offset": offset,
                    "order_by": order_by,
                    "order": order,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetTransformsV1TransformsGetResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_transform(self, transform_id: str) -> DeleteTransformResponse:
        """
        Parameters:
            - transform_id: str.
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.delete_transform(
            transform_id="transform_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DeleteTransformResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_transform_new_data(
        self,
        transform_id: str,
        *,
        callback_url: typing.Optional[str] = None,
        auth_key: typing.Optional[str] = None,
        include_reference: typing.Optional[bool] = None,
        reference_format: typing.Optional[str] = None,
    ) -> ReRunTransformResponse:
        """
        Run a transformation on data that have been added since the last run.

        Args:
        transform_id (str): The ID of the transformation.
        Returns:
        {"message": "Transformation initiated", "transform_id": transform_id}

        Parameters:
            - transform_id: str.

            - callback_url: typing.Optional[str].

            - auth_key: typing.Optional[str].

            - include_reference: typing.Optional[bool].

            - reference_format: typing.Optional[str].
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.run_transform_new_data(
            transform_id="transform_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}"),
            params=remove_none_from_dict(
                {
                    "callback_url": callback_url,
                    "auth_key": auth_key,
                    "include_reference": include_reference,
                    "reference_format": reference_format,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ReRunTransformResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_result_reference(
        self, *, transform_id: str, result_id: typing.Optional[str] = OMIT, column_name: typing.Optional[str] = OMIT
    ) -> GetTransformReferenceResponse:
        """
        Parameters:
            - transform_id: str.

            - result_id: typing.Optional[str]. result id to get reference for

            - column_name: typing.Optional[str]. column name to get reference for
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.get_result_reference(
            transform_id="transform_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"transform_id": transform_id}
        if result_id is not OMIT:
            _request["result_id"] = result_id
        if column_name is not OMIT:
            _request["column_name"] = column_name
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/transforms/reference"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetTransformReferenceResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def generate_autoschema(
        self, proj_name: str, *, num_field: typing.Optional[int] = None, num_docs: typing.Optional[int] = None
    ) -> CreateAutoschemaResponse:
        """
        Parameters:
            - proj_name: str. The name of the project for which the schema is being created.

            - num_field: typing.Optional[int]. The number of fields to include in the schema. Defaults to 10.

            - num_docs: typing.Optional[int]. The number of documents to generate based on the schema. Defaults to 3.
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.generate_autoschema(
            proj_name="proj_name",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/projects/{proj_name}/transforms/autoschema"
            ),
            params=remove_none_from_dict({"num_field": num_field, "num_docs": num_docs}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateAutoschemaResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def preview_transform(
        self, proj_name: str, *, num_assets: typing.Optional[int] = None, request: TransformParams
    ) -> TransformPreviewResponse:
        """
        Parameters:
            - proj_name: str. The name of the project for which to preview the transformation

            - num_assets: typing.Optional[int]. The number of assets to generate based on the schema. Defaults to 3.

            - request: TransformParams.
        ---
        from trellis import TransformationOperation, TransformParams
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.preview_transform(
            proj_name="proj_name",
            request=TransformParams(
                model="model",
                operations=[
                    TransformationOperation(
                        column_name="column_name",
                        column_type="column_type",
                        transform_type="transform_type",
                        task_description="task_description",
                    )
                ],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/projects/{proj_name}/transforms/create/preview"
            ),
            params=remove_none_from_dict({"num_assets": num_assets}),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TransformPreviewResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_transform_results(
        self,
        transform_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        order_by: typing.Optional[OrderByEnum] = None,
        order: typing.Optional[SortOrderEnum] = None,
    ) -> GetTransformResultsResponse:
        """
        Retrieve the results of a transformation for a given transform_id and customer.

        Parameters:

        - transform_id (str): The ID of the transformation.

        Returns:

        - Dict[List]: A list of rows representing the transformation results.

        Raises:

        - HTTPException: If the user does not have access to the transformation with the given transform_id.

        Parameters:
            - transform_id: str.

            - limit: typing.Optional[int].

            - offset: typing.Optional[int].

            - order_by: typing.Optional[OrderByEnum].

            - order: typing.Optional[SortOrderEnum].
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.get_transform_results(
            transform_id="transform_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/results"),
            params=remove_none_from_dict({"limit": limit, "offset": offset, "order_by": order_by, "order": order}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetTransformResultsResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_transform_result(
        self, transform_id: str, result_id: str, *, request: typing.Dict[str, typing.Any]
    ) -> UpdateTransformResultResponse:
        """
        Update the results of a transformation for a given transform_id and customer.

        Parameters:

        - transform_id (str): The ID of the transformation.
        - request (dict): The new results to update.

        Returns:

        - dict: A dictionary containing the updated transformation results.

        Raises:

        - HTTPException: If the user does not have access to the transformation with the given transform_id.

        Parameters:
            - transform_id: str.

            - result_id: str.

            - request: typing.Dict[str, typing.Any].
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.update_transform_result(
            transform_id="transform_id",
            result_id="result_id",
            request={"key": "value"},
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/results/{result_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateTransformResultResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def initiate_transform(
        self,
        *,
        proj_name: str,
        transform_name: typing.Optional[str] = OMIT,
        transform_params: TransformParams,
        include_reference: typing.Optional[bool] = OMIT,
        reference_format: typing.Optional[str] = OMIT,
        callback_url: typing.Optional[str] = OMIT,
        auth_key: typing.Optional[str] = OMIT,
        validation_params: typing.Optional[typing.List[ValidationParams]] = OMIT,
    ) -> InitiateTransformResponse:
        """
        Run the transformation defined in transformation params for all the assets in the project

        Args:
        transform_id (str): The ID of the transformation to run.

        Returns:
        {"message": "Transformation initiated", "transform_id": transform_id}

        Parameters:
            - proj_name: str.

            - transform_name: typing.Optional[str]. The transform_name parameter is an optional parameter that provides a human-readable name or description for the transformation, which can be useful for identifying and referencing transformations. If provided, the transform_name parameter should be a string. If not provided, the value of transform_name will be None.

            - transform_params: TransformParams.

            - include_reference: typing.Optional[bool]. The include_reference parameter is an optional parameter that specifies whether to include a reference to the original data in the transformation results. If set to True, the transformation results will include a reference to the original data. If set to False, the transformation results will not include a reference to the original data. The default value is True.

            - reference_format: typing.Optional[str]. The reference_format parameter is an optional parameter that specifies the format of the reference to the original data in the transformation results. The option is by_page or by_block

            - callback_url: typing.Optional[str]. The callback_url parameter is an optional parameter that specifies a URL to which the transformation results will be sent upon completion. If provided, the callback_url parameter should be a valid URL. If not provided, the value of transform_name will be None.

            - auth_key: typing.Optional[str]. The auth_key parameter is an optional parameter that will be an `Authorization` key that will be included in the header of the callback request to the `callback_url`. If not provided, the value of transform_name will be None.

            - validation_params: typing.Optional[typing.List[ValidationParams]].
        ---
        from trellis import TransformationOperation, TransformParams
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.transforms.initiate_transform(
            proj_name="proj_name",
            transform_params=TransformParams(
                model="model",
                operations=[
                    TransformationOperation(
                        column_name="column_name",
                        column_type="column_type",
                        transform_type="transform_type",
                        task_description="task_description",
                    )
                ],
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {"proj_name": proj_name, "transform_params": transform_params}
        if transform_name is not OMIT:
            _request["transform_name"] = transform_name
        if include_reference is not OMIT:
            _request["include_reference"] = include_reference
        if reference_format is not OMIT:
            _request["reference_format"] = reference_format
        if callback_url is not OMIT:
            _request["callback_url"] = callback_url
        if auth_key is not OMIT:
            _request["auth_key"] = auth_key
        if validation_params is not OMIT:
            _request["validation_params"] = validation_params
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/transforms/create"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(InitiateTransformResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncTransformsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_transforms(
        self,
        *,
        transform_ids: typing.Optional[typing.Union[str, typing.List[str]]] = None,
        proj_names: typing.Optional[typing.Union[str, typing.List[str]]] = None,
        include_params: typing.Optional[bool] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        order_by: typing.Optional[OrderByEnum] = None,
        order: typing.Optional[SortOrderEnum] = None,
    ) -> GetTransformsV1TransformsGetResponse:
        """
        Retrieve all transformation associated with you.

        Parameters:

        - limit (int): The number of transformations to retrieve.
        - offset (int): The offset to start retrieving transformations from.
        - order_by (str): The column to order the transformations by.
        - order (str): The order to sort the transformations by.
        - transform_ids (list, optional): The IDs of the transformations to retrieve.
        - proj_names (list, optional): The names of the projects to retrieve transformations from.
        - include_params (bool, optional): Include metadata in the response such as the transform_params and validation_params. Defaults to false.

        Returns:

        - dict: A dict containing all the transformations associated with you.

        Parameters:
            - transform_ids: typing.Optional[typing.Union[str, typing.List[str]]]. List of transform IDs to retrieve.

            - proj_names: typing.Optional[typing.Union[str, typing.List[str]]]. List of project names to retrieve transformations from.

            - include_params: typing.Optional[bool]. Boolean flag to include params in the response such as the transform_params and validation_params.

            - limit: typing.Optional[int].

            - offset: typing.Optional[int].

            - order_by: typing.Optional[OrderByEnum].

            - order: typing.Optional[SortOrderEnum].
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/transforms"),
            params=remove_none_from_dict(
                {
                    "transform_ids": transform_ids,
                    "proj_names": proj_names,
                    "include_params": include_params,
                    "limit": limit,
                    "offset": offset,
                    "order_by": order_by,
                    "order": order,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetTransformsV1TransformsGetResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_transform(self, transform_id: str) -> DeleteTransformResponse:
        """
        Parameters:
            - transform_id: str.
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.delete_transform(
            transform_id="transform_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DeleteTransformResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_transform_new_data(
        self,
        transform_id: str,
        *,
        callback_url: typing.Optional[str] = None,
        auth_key: typing.Optional[str] = None,
        include_reference: typing.Optional[bool] = None,
        reference_format: typing.Optional[str] = None,
    ) -> ReRunTransformResponse:
        """
        Run a transformation on data that have been added since the last run.

        Args:
        transform_id (str): The ID of the transformation.
        Returns:
        {"message": "Transformation initiated", "transform_id": transform_id}

        Parameters:
            - transform_id: str.

            - callback_url: typing.Optional[str].

            - auth_key: typing.Optional[str].

            - include_reference: typing.Optional[bool].

            - reference_format: typing.Optional[str].
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.run_transform_new_data(
            transform_id="transform_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}"),
            params=remove_none_from_dict(
                {
                    "callback_url": callback_url,
                    "auth_key": auth_key,
                    "include_reference": include_reference,
                    "reference_format": reference_format,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ReRunTransformResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_result_reference(
        self, *, transform_id: str, result_id: typing.Optional[str] = OMIT, column_name: typing.Optional[str] = OMIT
    ) -> GetTransformReferenceResponse:
        """
        Parameters:
            - transform_id: str.

            - result_id: typing.Optional[str]. result id to get reference for

            - column_name: typing.Optional[str]. column name to get reference for
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.get_result_reference(
            transform_id="transform_id",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"transform_id": transform_id}
        if result_id is not OMIT:
            _request["result_id"] = result_id
        if column_name is not OMIT:
            _request["column_name"] = column_name
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/transforms/reference"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetTransformReferenceResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def generate_autoschema(
        self, proj_name: str, *, num_field: typing.Optional[int] = None, num_docs: typing.Optional[int] = None
    ) -> CreateAutoschemaResponse:
        """
        Parameters:
            - proj_name: str. The name of the project for which the schema is being created.

            - num_field: typing.Optional[int]. The number of fields to include in the schema. Defaults to 10.

            - num_docs: typing.Optional[int]. The number of documents to generate based on the schema. Defaults to 3.
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.generate_autoschema(
            proj_name="proj_name",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/projects/{proj_name}/transforms/autoschema"
            ),
            params=remove_none_from_dict({"num_field": num_field, "num_docs": num_docs}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateAutoschemaResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def preview_transform(
        self, proj_name: str, *, num_assets: typing.Optional[int] = None, request: TransformParams
    ) -> TransformPreviewResponse:
        """
        Parameters:
            - proj_name: str. The name of the project for which to preview the transformation

            - num_assets: typing.Optional[int]. The number of assets to generate based on the schema. Defaults to 3.

            - request: TransformParams.
        ---
        from trellis import TransformationOperation, TransformParams
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.preview_transform(
            proj_name="proj_name",
            request=TransformParams(
                model="model",
                operations=[
                    TransformationOperation(
                        column_name="column_name",
                        column_type="column_type",
                        transform_type="transform_type",
                        task_description="task_description",
                    )
                ],
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/projects/{proj_name}/transforms/create/preview"
            ),
            params=remove_none_from_dict({"num_assets": num_assets}),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(TransformPreviewResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_transform_results(
        self,
        transform_id: str,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        order_by: typing.Optional[OrderByEnum] = None,
        order: typing.Optional[SortOrderEnum] = None,
    ) -> GetTransformResultsResponse:
        """
        Retrieve the results of a transformation for a given transform_id and customer.

        Parameters:

        - transform_id (str): The ID of the transformation.

        Returns:

        - Dict[List]: A list of rows representing the transformation results.

        Raises:

        - HTTPException: If the user does not have access to the transformation with the given transform_id.

        Parameters:
            - transform_id: str.

            - limit: typing.Optional[int].

            - offset: typing.Optional[int].

            - order_by: typing.Optional[OrderByEnum].

            - order: typing.Optional[SortOrderEnum].
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.get_transform_results(
            transform_id="transform_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/results"),
            params=remove_none_from_dict({"limit": limit, "offset": offset, "order_by": order_by, "order": order}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetTransformResultsResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_transform_result(
        self, transform_id: str, result_id: str, *, request: typing.Dict[str, typing.Any]
    ) -> UpdateTransformResultResponse:
        """
        Update the results of a transformation for a given transform_id and customer.

        Parameters:

        - transform_id (str): The ID of the transformation.
        - request (dict): The new results to update.

        Returns:

        - dict: A dictionary containing the updated transformation results.

        Raises:

        - HTTPException: If the user does not have access to the transformation with the given transform_id.

        Parameters:
            - transform_id: str.

            - result_id: str.

            - request: typing.Dict[str, typing.Any].
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.update_transform_result(
            transform_id="transform_id",
            result_id="result_id",
            request={"key": "value"},
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/results/{result_id}"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateTransformResultResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def initiate_transform(
        self,
        *,
        proj_name: str,
        transform_name: typing.Optional[str] = OMIT,
        transform_params: TransformParams,
        include_reference: typing.Optional[bool] = OMIT,
        reference_format: typing.Optional[str] = OMIT,
        callback_url: typing.Optional[str] = OMIT,
        auth_key: typing.Optional[str] = OMIT,
        validation_params: typing.Optional[typing.List[ValidationParams]] = OMIT,
    ) -> InitiateTransformResponse:
        """
        Run the transformation defined in transformation params for all the assets in the project

        Args:
        transform_id (str): The ID of the transformation to run.

        Returns:
        {"message": "Transformation initiated", "transform_id": transform_id}

        Parameters:
            - proj_name: str.

            - transform_name: typing.Optional[str]. The transform_name parameter is an optional parameter that provides a human-readable name or description for the transformation, which can be useful for identifying and referencing transformations. If provided, the transform_name parameter should be a string. If not provided, the value of transform_name will be None.

            - transform_params: TransformParams.

            - include_reference: typing.Optional[bool]. The include_reference parameter is an optional parameter that specifies whether to include a reference to the original data in the transformation results. If set to True, the transformation results will include a reference to the original data. If set to False, the transformation results will not include a reference to the original data. The default value is True.

            - reference_format: typing.Optional[str]. The reference_format parameter is an optional parameter that specifies the format of the reference to the original data in the transformation results. The option is by_page or by_block

            - callback_url: typing.Optional[str]. The callback_url parameter is an optional parameter that specifies a URL to which the transformation results will be sent upon completion. If provided, the callback_url parameter should be a valid URL. If not provided, the value of transform_name will be None.

            - auth_key: typing.Optional[str]. The auth_key parameter is an optional parameter that will be an `Authorization` key that will be included in the header of the callback request to the `callback_url`. If not provided, the value of transform_name will be None.

            - validation_params: typing.Optional[typing.List[ValidationParams]].
        ---
        from trellis import TransformationOperation, TransformParams
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.transforms.initiate_transform(
            proj_name="proj_name",
            transform_params=TransformParams(
                model="model",
                operations=[
                    TransformationOperation(
                        column_name="column_name",
                        column_type="column_type",
                        transform_type="transform_type",
                        task_description="task_description",
                    )
                ],
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {"proj_name": proj_name, "transform_params": transform_params}
        if transform_name is not OMIT:
            _request["transform_name"] = transform_name
        if include_reference is not OMIT:
            _request["include_reference"] = include_reference
        if reference_format is not OMIT:
            _request["reference_format"] = reference_format
        if callback_url is not OMIT:
            _request["callback_url"] = callback_url
        if auth_key is not OMIT:
            _request["auth_key"] = auth_key
        if validation_params is not OMIT:
            _request["validation_params"] = validation_params
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "v1/transforms/create"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(InitiateTransformResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
