# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...errors.not_found_error import NotFoundError
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.delete_validation_param_response import DeleteValidationParamResponse
from ...types.get_validation_param_response import GetValidationParamResponse
from ...types.http_validation_error import HttpValidationError
from ...types.insert_validation_param_response import InsertValidationParamResponse
from ...types.update_validation_param_response import UpdateValidationParamResponse
from ...types.validation_params import ValidationParams

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ValidationParamsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_all_validation_params(self, transform_id: str) -> GetValidationParamResponse:
        """
        Parameters:
            - transform_id: str.
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.validation_params.get_all_validation_params(
            transform_id="transform_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/validations/params"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def insert_validation_params(
        self, transform_id: str, *, request: ValidationParams
    ) -> InsertValidationParamResponse:
        """
        Parameters:
            - transform_id: str.

            - request: ValidationParams.
        ---
        from trellis import ValidationParams
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.validation_params.insert_validation_params(
            transform_id="transform_id",
            request=ValidationParams(
                validation_name="validation_name",
                validation_columns=["validation_columns"],
                validation_rule="validation_rule",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/validations/params"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(InsertValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_validation_params(
        self, transform_id: str, validation_param_id: str, *, request: ValidationParams
    ) -> UpdateValidationParamResponse:
        """
        "
        Update a validation parameter for a given transformation.

        Args:
        transform_id (str): The ID of the transformation.
        validation_param_id (str): The ID of the validation parameter.
        validation_param (ValidationParams): The updated validation parameter data.

        Returns:
        dict: A dictionary containing a success message and the updated validation parameter data.

        Raises:
        HTTPException: If the transformation does not exist for the current customer, or if an error occurs during the update process.

        Parameters:
            - transform_id: str.

            - validation_param_id: str.

            - request: ValidationParams.
        ---
        from trellis import ValidationParams
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.validation_params.update_validation_params(
            transform_id="transform_id",
            validation_param_id="validation_param_id",
            request=ValidationParams(
                validation_name="validation_name",
                validation_columns=["validation_columns"],
                validation_rule="validation_rule",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"v1/transforms/{transform_id}/validations/params/{validation_param_id}",
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_validation_params(self, transform_id: str, validation_param_id: str) -> DeleteValidationParamResponse:
        """
        Parameters:
            - transform_id: str.

            - validation_param_id: str.
        ---
        from trellis.client import TrellisApi

        client = TrellisApi(
            api_key="YOUR_API_KEY",
        )
        client.validation_params.delete_validation_params(
            transform_id="transform_id",
            validation_param_id="validation_param_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"v1/transforms/{transform_id}/validations/params/{validation_param_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DeleteValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncValidationParamsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_all_validation_params(self, transform_id: str) -> GetValidationParamResponse:
        """
        Parameters:
            - transform_id: str.
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.validation_params.get_all_validation_params(
            transform_id="transform_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/validations/params"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def insert_validation_params(
        self, transform_id: str, *, request: ValidationParams
    ) -> InsertValidationParamResponse:
        """
        Parameters:
            - transform_id: str.

            - request: ValidationParams.
        ---
        from trellis import ValidationParams
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.validation_params.insert_validation_params(
            transform_id="transform_id",
            request=ValidationParams(
                validation_name="validation_name",
                validation_columns=["validation_columns"],
                validation_rule="validation_rule",
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"v1/transforms/{transform_id}/validations/params"
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(InsertValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_validation_params(
        self, transform_id: str, validation_param_id: str, *, request: ValidationParams
    ) -> UpdateValidationParamResponse:
        """
        "
        Update a validation parameter for a given transformation.

        Args:
        transform_id (str): The ID of the transformation.
        validation_param_id (str): The ID of the validation parameter.
        validation_param (ValidationParams): The updated validation parameter data.

        Returns:
        dict: A dictionary containing a success message and the updated validation parameter data.

        Raises:
        HTTPException: If the transformation does not exist for the current customer, or if an error occurs during the update process.

        Parameters:
            - transform_id: str.

            - validation_param_id: str.

            - request: ValidationParams.
        ---
        from trellis import ValidationParams
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.validation_params.update_validation_params(
            transform_id="transform_id",
            validation_param_id="validation_param_id",
            request=ValidationParams(
                validation_name="validation_name",
                validation_columns=["validation_columns"],
                validation_rule="validation_rule",
            ),
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "PUT",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"v1/transforms/{transform_id}/validations/params/{validation_param_id}",
            ),
            json=jsonable_encoder(request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_validation_params(
        self, transform_id: str, validation_param_id: str
    ) -> DeleteValidationParamResponse:
        """
        Parameters:
            - transform_id: str.

            - validation_param_id: str.
        ---
        from trellis.client import AsyncTrellisApi

        client = AsyncTrellisApi(
            api_key="YOUR_API_KEY",
        )
        await client.validation_params.delete_validation_params(
            transform_id="transform_id",
            validation_param_id="validation_param_id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/",
                f"v1/transforms/{transform_id}/validations/params/{validation_param_id}",
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DeleteValidationParamResponse, _response.json())  # type: ignore
        if _response.status_code == 404:
            raise NotFoundError(pydantic.parse_obj_as(typing.Any, _response.json()))  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
