# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .transformation_operation import TransformationOperation

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TransformParams(pydantic.BaseModel):
    model: str = pydantic.Field(
        description="The model to be used for the transformation. Must be one of 'trellis-turbo', 'trellis-vertix', 'trellis-warp', 'trellis-scale', 'trellis-turbo-32k', 'trellis-premium', or 'trellis-enterprise'"
    )
    mode: typing.Optional[str] = pydantic.Field(
        description="The mode to be used for the transformation. Must be one of 'document' or 'table'"
    )
    operations: typing.List[TransformationOperation]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
