# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TransformationOperation(pydantic.BaseModel):
    column_name: str = pydantic.Field(
        description="Name of the column to be transformed. Only lower-case letters and underscores or dashes are allowed. No spaces."
    )
    column_type: str = pydantic.Field(
        description="Type of the column to be transformed. Must be one of 'boolean', 'numeric', or 'text'"
    )
    transform_type: str = pydantic.Field(
        description="Type of transformation to be applied. Must be one of 'extraction', 'classification', or 'generation'"
    )
    task_description: str = pydantic.Field(description="Description of the task to be performed")
    output_values: typing.Optional[typing.Dict[str, str]] = pydantic.Field(
        description="NOTE: only valid with classifcation tasks. Output values of the transformation operation. A dictionary where the keys represent the classification bucket and the values represent the classifcation meaning. Example: {'likely': 'This is a customer who has said they will make a purcahse in the next 30 days', 'unlikely': 'This is a customer who has said they will not make a purchase in the next 30 days', 'unsure': 'This is a customer who has not committed to anything'}."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
