# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import List

import httpx

from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ..._utils import (
    maybe_transform,
    strip_not_given,
    async_maybe_transform,
)
from ..._compat import cached_property
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._base_client import make_request_options
from ...types.events import action_delete_params
from ...types.events.event_action import EventAction

__all__ = ["ActionsResource", "AsyncActionsResource"]


class ActionsResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> ActionsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#accessing-raw-response-data-eg-headers
        """
        return ActionsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> ActionsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#with_streaming_response
        """
        return ActionsResourceWithStreamingResponse(self)

    def delete(
        self,
        *,
        action_ids: List[str] | NotGiven = NOT_GIVEN,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> EventAction:
        """
        Delete Event Subscription Action

        Args:
          action_ids: List of event subscription action ids to delete

          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return self._delete(
            "/v1/events/actions",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform({"action_ids": action_ids}, action_delete_params.ActionDeleteParams),
            ),
            cast_to=EventAction,
        )


class AsyncActionsResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncActionsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#accessing-raw-response-data-eg-headers
        """
        return AsyncActionsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncActionsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#with_streaming_response
        """
        return AsyncActionsResourceWithStreamingResponse(self)

    async def delete(
        self,
        *,
        action_ids: List[str] | NotGiven = NOT_GIVEN,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> EventAction:
        """
        Delete Event Subscription Action

        Args:
          action_ids: List of event subscription action ids to delete

          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return await self._delete(
            "/v1/events/actions",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=await async_maybe_transform({"action_ids": action_ids}, action_delete_params.ActionDeleteParams),
            ),
            cast_to=EventAction,
        )


class ActionsResourceWithRawResponse:
    def __init__(self, actions: ActionsResource) -> None:
        self._actions = actions

        self.delete = to_raw_response_wrapper(
            actions.delete,
        )


class AsyncActionsResourceWithRawResponse:
    def __init__(self, actions: AsyncActionsResource) -> None:
        self._actions = actions

        self.delete = async_to_raw_response_wrapper(
            actions.delete,
        )


class ActionsResourceWithStreamingResponse:
    def __init__(self, actions: ActionsResource) -> None:
        self._actions = actions

        self.delete = to_streamed_response_wrapper(
            actions.delete,
        )


class AsyncActionsResourceWithStreamingResponse:
    def __init__(self, actions: AsyncActionsResource) -> None:
        self._actions = actions

        self.delete = async_to_streamed_response_wrapper(
            actions.delete,
        )
