# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import List

import httpx

from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ..._utils import (
    maybe_transform,
    strip_not_given,
    async_maybe_transform,
)
from ..._compat import cached_property
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._base_client import make_request_options
from ...types.templates import category_list_params, category_create_params, category_update_params
from ...types.templates.template_category import TemplateCategory
from ...types.templates.category_list_response import CategoryListResponse
from ...types.templates.category_delete_response import CategoryDeleteResponse
from ...types.templates.category_update_response import CategoryUpdateResponse

__all__ = ["CategoriesResource", "AsyncCategoriesResource"]


class CategoriesResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> CategoriesResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#accessing-raw-response-data-eg-headers
        """
        return CategoriesResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> CategoriesResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#with_streaming_response
        """
        return CategoriesResourceWithStreamingResponse(self)

    def create(
        self,
        *,
        description: str,
        name: str,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> TemplateCategory:
        """
        Create Category

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return self._post(
            "/v1/templates/categories",
            body=maybe_transform(
                {
                    "description": description,
                    "name": name,
                },
                category_create_params.CategoryCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=TemplateCategory,
        )

    def update(
        self,
        category_id: str,
        *,
        description: str,
        name: str,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> CategoryUpdateResponse:
        """
        Update Category

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not category_id:
            raise ValueError(f"Expected a non-empty value for `category_id` but received {category_id!r}")
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return self._put(
            f"/v1/templates/categories/{category_id}",
            body=maybe_transform(
                {
                    "description": description,
                    "name": name,
                },
                category_update_params.CategoryUpdateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=CategoryUpdateResponse,
        )

    def list(
        self,
        *,
        category_ids: List[str] | NotGiven = NOT_GIVEN,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> CategoryListResponse:
        """
        Get Categories

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return self._get(
            "/v1/templates/categories",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform({"category_ids": category_ids}, category_list_params.CategoryListParams),
            ),
            cast_to=CategoryListResponse,
        )

    def delete(
        self,
        category_id: str,
        *,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> CategoryDeleteResponse:
        """
        Delete Category

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not category_id:
            raise ValueError(f"Expected a non-empty value for `category_id` but received {category_id!r}")
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return self._delete(
            f"/v1/templates/categories/{category_id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=CategoryDeleteResponse,
        )


class AsyncCategoriesResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncCategoriesResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#accessing-raw-response-data-eg-headers
        """
        return AsyncCategoriesResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncCategoriesResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Trellis-insights/trellis-python-sdk#with_streaming_response
        """
        return AsyncCategoriesResourceWithStreamingResponse(self)

    async def create(
        self,
        *,
        description: str,
        name: str,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> TemplateCategory:
        """
        Create Category

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return await self._post(
            "/v1/templates/categories",
            body=await async_maybe_transform(
                {
                    "description": description,
                    "name": name,
                },
                category_create_params.CategoryCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=TemplateCategory,
        )

    async def update(
        self,
        category_id: str,
        *,
        description: str,
        name: str,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> CategoryUpdateResponse:
        """
        Update Category

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not category_id:
            raise ValueError(f"Expected a non-empty value for `category_id` but received {category_id!r}")
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return await self._put(
            f"/v1/templates/categories/{category_id}",
            body=await async_maybe_transform(
                {
                    "description": description,
                    "name": name,
                },
                category_update_params.CategoryUpdateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=CategoryUpdateResponse,
        )

    async def list(
        self,
        *,
        category_ids: List[str] | NotGiven = NOT_GIVEN,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> CategoryListResponse:
        """
        Get Categories

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return await self._get(
            "/v1/templates/categories",
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=await async_maybe_transform(
                    {"category_ids": category_ids}, category_list_params.CategoryListParams
                ),
            ),
            cast_to=CategoryListResponse,
        )

    async def delete(
        self,
        category_id: str,
        *,
        api_version: str | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> CategoryDeleteResponse:
        """
        Delete Category

        Args:
          api_version: Pass in an API version to guarantee a consistent response format.The latest
              version should be used for all new API calls. Existing API calls should be
              updated to the latest version when possible.

              **Valid versions:**

              - Latest API version (recommended): `2025-03`

              - Previous API version (maintenance mode): `2025-02`

              If no API version header is included, the response format is considered unstable
              and could change without notice (not recommended).

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not category_id:
            raise ValueError(f"Expected a non-empty value for `category_id` but received {category_id!r}")
        extra_headers = {**strip_not_given({"API-Version": api_version}), **(extra_headers or {})}
        return await self._delete(
            f"/v1/templates/categories/{category_id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=CategoryDeleteResponse,
        )


class CategoriesResourceWithRawResponse:
    def __init__(self, categories: CategoriesResource) -> None:
        self._categories = categories

        self.create = to_raw_response_wrapper(
            categories.create,
        )
        self.update = to_raw_response_wrapper(
            categories.update,
        )
        self.list = to_raw_response_wrapper(
            categories.list,
        )
        self.delete = to_raw_response_wrapper(
            categories.delete,
        )


class AsyncCategoriesResourceWithRawResponse:
    def __init__(self, categories: AsyncCategoriesResource) -> None:
        self._categories = categories

        self.create = async_to_raw_response_wrapper(
            categories.create,
        )
        self.update = async_to_raw_response_wrapper(
            categories.update,
        )
        self.list = async_to_raw_response_wrapper(
            categories.list,
        )
        self.delete = async_to_raw_response_wrapper(
            categories.delete,
        )


class CategoriesResourceWithStreamingResponse:
    def __init__(self, categories: CategoriesResource) -> None:
        self._categories = categories

        self.create = to_streamed_response_wrapper(
            categories.create,
        )
        self.update = to_streamed_response_wrapper(
            categories.update,
        )
        self.list = to_streamed_response_wrapper(
            categories.list,
        )
        self.delete = to_streamed_response_wrapper(
            categories.delete,
        )


class AsyncCategoriesResourceWithStreamingResponse:
    def __init__(self, categories: AsyncCategoriesResource) -> None:
        self._categories = categories

        self.create = async_to_streamed_response_wrapper(
            categories.create,
        )
        self.update = async_to_streamed_response_wrapper(
            categories.update,
        )
        self.list = async_to_streamed_response_wrapper(
            categories.list,
        )
        self.delete = async_to_streamed_response_wrapper(
            categories.delete,
        )
