# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and it's members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from tremendous.models.create_report_request_filters_digital_rewards_amount import CreateReportRequestFiltersDigitalRewardsAmount
from tremendous.models.create_report_request_filters_digital_rewards_created_at import CreateReportRequestFiltersDigitalRewardsCreatedAt
from typing import Optional, Set
from typing_extensions import Self

class CreateReportRequestFiltersDigitalRewards(BaseModel):
    """
    Filters object for a `report_type: digital_rewards` report 
    """ # noqa: E501
    amount: Optional[CreateReportRequestFiltersDigitalRewardsAmount] = None
    campaign_id: Optional[StrictStr] = Field(default=None, description="ID of the Tremendous campaign that this report should be limited to ")
    created_at: Optional[CreateReportRequestFiltersDigitalRewardsCreatedAt] = None
    delivered_at: Optional[date] = Field(default=None, description="Delivery date for gifts that should be returned in the report ")
    delivery_method: Optional[StrictStr] = Field(default=None, description="Delivery method for rewards returned in the report ")
    order_id: Optional[StrictStr] = Field(default=None, description="ID of the Tremendous order that this report should be limited to ")
    order_status: Optional[StrictStr] = Field(default=None, description="Order status for rewards returned in the report ")
    status: Optional[List[StrictStr]] = Field(default=None, description="Status for rewards returned in the report ")
    __properties: ClassVar[List[str]] = ["amount", "campaign_id", "created_at", "delivered_at", "delivery_method", "order_id", "order_status", "status"]

    @field_validator('delivery_method')
    def delivery_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['phone', 'email', 'link', 'mail', 'direct']):
            raise ValueError("must be one of enum values ('phone', 'email', 'link', 'mail', 'direct')")
        return value

    @field_validator('order_status')
    def order_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['executed', 'canceled', 'failed', 'pending_approval']):
            raise ValueError("must be one of enum values ('executed', 'canceled', 'failed', 'pending_approval')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['delivered', 'canceled', 'delivery_failed', 'pending_review']):
                raise ValueError("each list item must be one of ('delivered', 'canceled', 'delivery_failed', 'pending_review')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateReportRequestFiltersDigitalRewards from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_at
        if self.created_at:
            _dict['created_at'] = self.created_at.to_dict()
        # set to None if amount (nullable) is None
        # and model_fields_set contains the field
        if self.amount is None and "amount" in self.model_fields_set:
            _dict['amount'] = None

        # set to None if campaign_id (nullable) is None
        # and model_fields_set contains the field
        if self.campaign_id is None and "campaign_id" in self.model_fields_set:
            _dict['campaign_id'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['created_at'] = None

        # set to None if delivered_at (nullable) is None
        # and model_fields_set contains the field
        if self.delivered_at is None and "delivered_at" in self.model_fields_set:
            _dict['delivered_at'] = None

        # set to None if delivery_method (nullable) is None
        # and model_fields_set contains the field
        if self.delivery_method is None and "delivery_method" in self.model_fields_set:
            _dict['delivery_method'] = None

        # set to None if order_id (nullable) is None
        # and model_fields_set contains the field
        if self.order_id is None and "order_id" in self.model_fields_set:
            _dict['order_id'] = None

        # set to None if order_status (nullable) is None
        # and model_fields_set contains the field
        if self.order_status is None and "order_status" in self.model_fields_set:
            _dict['order_status'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateReportRequestFiltersDigitalRewards from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": CreateReportRequestFiltersDigitalRewardsAmount.from_dict(obj["amount"]) if obj.get("amount") is not None else None,
            "campaign_id": obj.get("campaign_id"),
            "created_at": CreateReportRequestFiltersDigitalRewardsCreatedAt.from_dict(obj["created_at"]) if obj.get("created_at") is not None else None,
            "delivered_at": obj.get("delivered_at"),
            "delivery_method": obj.get("delivery_method"),
            "order_id": obj.get("order_id"),
            "order_status": obj.get("order_status"),
            "status": obj.get("status")
        })
        return _obj


