# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and its members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class FraudRuleType(str, Enum):
    """
    * `review_country` - Flags when the recipient's IP country matches the criteria in the rule * `review_ip` - Flags when recipient's IP matches one in the list * `review_email` - Flags when the recipient's email matches one in the list * `review_redeemed_rewards_count` - Flags when the recipient redeemed more than the number of rewards specified in the config * `review_redeemed_rewards_amount` - Flags when the recipient redeemed more than the total amount specified in the config * `review_multiple_emails` - Flags when recipient's device or account has multiple emails associated * `review_vpn` - Flags when VPN is suspected * `review_tremendous_flag_list` - Flags rewards when redemption attributes match at least one criteria defined by the Tremendous flag list * `review_previously_blocked_recipients` - Flags rewards when the recipient has been blocked before * `allow_ip` - Releases a reward when a recipient's IP matches one in the list * `allow_email` - Releases a reward when the recipient's email matches one in the list 
    """

    """
    allowed enum values
    """
    REVIEW_COUNTRY = 'review_country'
    REVIEW_IP = 'review_ip'
    REVIEW_EMAIL = 'review_email'
    REVIEW_REDEEMED_REWARDS_COUNT = 'review_redeemed_rewards_count'
    REVIEW_REDEEMED_REWARDS_AMOUNT = 'review_redeemed_rewards_amount'
    REVIEW_MULTIPLE_EMAILS = 'review_multiple_emails'
    REVIEW_VPN = 'review_vpn'
    REVIEW_TREMENDOUS_FLAG_LIST = 'review_tremendous_flag_list'
    REVIEW_PREVIOUSLY_BLOCKED_RECIPIENTS = 'review_previously_blocked_recipients'
    ALLOW_IP = 'allow_ip'
    ALLOW_EMAIL = 'allow_email'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FraudRuleType from a JSON string"""
        return cls(json.loads(json_str))


