# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and its members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from tremendous.models.list_funding_sources200_response_funding_sources_inner_meta_failure_details import ListFundingSources200ResponseFundingSourcesInnerMetaFailureDetails
from typing import Optional, Set
from typing_extensions import Self

class ListFundingSources200ResponseFundingSourcesInnerMeta(BaseModel):
    """
    ListFundingSources200ResponseFundingSourcesInnerMeta
    """ # noqa: E501
    available_cents: Optional[StrictInt] = Field(default=None, description="**Only exists for balance and commercial invoicing.**  For balance: available amount (in cents USD) For commercial invoicing: available credit amount calculated as (credit limit - outstanding balance) (in cents USD) ")
    pending_cents: Optional[StrictInt] = Field(default=None, description="**Only available when `method` is set to `balance`.**  Funds that are already registered on your Tremendous account but which have not yet been deposited in your account (e.g. unpaid invoices) (in Cents USD). ")
    credit_limit_cents: Optional[StrictInt] = Field(default=None, description="**Only exists for commercial invoicing.**  Available credit limit (in cents USD) ")
    accountholder_name: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `bank_account` or `credit_card`.**  Name of the holder of the bank account or credit_card ")
    account_type: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `bank_account`.**  Is this a checking or savings account ")
    bank_name: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `bank_account`.**  Name of the bank ")
    account_number_mask: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="**Only available when `method` is set to `bank_account`.**  Last 4 digits of the account number ")
    account_routing_mask: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="**Only available when `method` is set to `bank_account`.**  Last 4 digits of the routing number ")
    refundable: Optional[StrictBool] = Field(default=None, description="**Only available when `method` is set to `bank_account`.**  Can refunds be deposited to this bank account ")
    network: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `credit_card`.**  Network of the credit card ")
    last4: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="**Only available when `method` is set to `credit_card`.**  Last 4 digits of the credit card number ")
    expired: Optional[StrictBool] = Field(default=None, description="**Only available when `method` is set to `credit_card`.**  Is this credit card expired ")
    year: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `credit_card`.**  Year part of card's expiration date ")
    month: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `credit_card`.**  Month part of card's expiration date ")
    last_payment_failed_at: Optional[datetime] = Field(default=None, description="**Only available when `method` is set to `bank_account` or `credit_card`.**  Point in time when the last order failed using this bank account or credit card as a funding source. ")
    invoice_type: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Type of invoice account (e.g., commercial, pro_forma, prefunding_only) ")
    interval: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice` and `invoice_type` is `commercial`.**  Billing interval for commercial invoice generation (e.g., daily, weekly, monthly, twice_monthly). Returns `null` for pro forma invoices. ")
    day_of_week: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice` and `invoice_type` is `commercial`.**  Day of the week when commercial invoices are generated (\"0\"=Sunday, \"1\"=Monday, etc.). Returns `null` for pro forma invoices. ")
    net: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Net payment terms in days (e.g., \"30\" for Net 30) ")
    company_name: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Company name for invoice billing ")
    address_1: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Primary billing address line ")
    address_2: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Secondary billing address line ")
    city: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Billing address city ")
    state: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Billing address state or province ")
    zip: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Billing address postal code ")
    phone: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Contact phone number for billing ")
    emails: Optional[StrictStr] = Field(default=None, description="**Only available when `method` is set to `invoice`.**  Email addresses for invoice delivery (comma-separated) ")
    failure_details: Optional[ListFundingSources200ResponseFundingSourcesInnerMetaFailureDetails] = None
    __properties: ClassVar[List[str]] = ["available_cents", "pending_cents", "credit_limit_cents", "accountholder_name", "account_type", "bank_name", "account_number_mask", "account_routing_mask", "refundable", "network", "last4", "expired", "year", "month", "last_payment_failed_at", "invoice_type", "interval", "day_of_week", "net", "company_name", "address_1", "address_2", "city", "state", "zip", "phone", "emails", "failure_details"]

    @field_validator('account_type')
    def account_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['checking', 'savings']):
            raise ValueError("must be one of enum values ('checking', 'savings')")
        return value

    @field_validator('account_number_mask')
    def account_number_mask_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[0-9]{4}", value):
            raise ValueError(r"must validate the regular expression /[0-9]{4}/")
        return value

    @field_validator('account_routing_mask')
    def account_routing_mask_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[0-9]{4}", value):
            raise ValueError(r"must validate the regular expression /[0-9]{4}/")
        return value

    @field_validator('network')
    def network_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MasterCard', 'Amex', 'JCB', 'Diner\'s Club', 'Visa', 'Discover', 'Laser', 'Elo', 'Maestro', 'Solo']):
            raise ValueError("must be one of enum values ('MasterCard', 'Amex', 'JCB', 'Diner\'s Club', 'Visa', 'Discover', 'Laser', 'Elo', 'Maestro', 'Solo')")
        return value

    @field_validator('last4')
    def last4_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"[0-9]{4}", value):
            raise ValueError(r"must validate the regular expression /[0-9]{4}/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListFundingSources200ResponseFundingSourcesInnerMeta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of failure_details
        if self.failure_details:
            _dict['failure_details'] = self.failure_details.to_dict()
        # set to None if bank_name (nullable) is None
        # and model_fields_set contains the field
        if self.bank_name is None and "bank_name" in self.model_fields_set:
            _dict['bank_name'] = None

        # set to None if last_payment_failed_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_payment_failed_at is None and "last_payment_failed_at" in self.model_fields_set:
            _dict['last_payment_failed_at'] = None

        # set to None if interval (nullable) is None
        # and model_fields_set contains the field
        if self.interval is None and "interval" in self.model_fields_set:
            _dict['interval'] = None

        # set to None if day_of_week (nullable) is None
        # and model_fields_set contains the field
        if self.day_of_week is None and "day_of_week" in self.model_fields_set:
            _dict['day_of_week'] = None

        # set to None if failure_details (nullable) is None
        # and model_fields_set contains the field
        if self.failure_details is None and "failure_details" in self.model_fields_set:
            _dict['failure_details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListFundingSources200ResponseFundingSourcesInnerMeta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "available_cents": obj.get("available_cents"),
            "pending_cents": obj.get("pending_cents"),
            "credit_limit_cents": obj.get("credit_limit_cents"),
            "accountholder_name": obj.get("accountholder_name"),
            "account_type": obj.get("account_type"),
            "bank_name": obj.get("bank_name"),
            "account_number_mask": obj.get("account_number_mask"),
            "account_routing_mask": obj.get("account_routing_mask"),
            "refundable": obj.get("refundable"),
            "network": obj.get("network"),
            "last4": obj.get("last4"),
            "expired": obj.get("expired"),
            "year": obj.get("year"),
            "month": obj.get("month"),
            "last_payment_failed_at": obj.get("last_payment_failed_at"),
            "invoice_type": obj.get("invoice_type"),
            "interval": obj.get("interval"),
            "day_of_week": obj.get("day_of_week"),
            "net": obj.get("net"),
            "company_name": obj.get("company_name"),
            "address_1": obj.get("address_1"),
            "address_2": obj.get("address_2"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "zip": obj.get("zip"),
            "phone": obj.get("phone"),
            "emails": obj.get("emails"),
            "failure_details": ListFundingSources200ResponseFundingSourcesInnerMetaFailureDetails.from_dict(obj["failure_details"]) if obj.get("failure_details") is not None else None
        })
        return _obj


