# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and its members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListTopups200ResponseTopupsInner(BaseModel):
    """
    ListTopups200ResponseTopupsInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the topup request.")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount in USD intended to be added to your organization’s balance.")
    processing_fee: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Amount of the processing fee for the topup (typically reserved for credit card topups).")
    funding_source_id: Optional[StrictStr] = Field(default=None, description="ID of the funding_source object used for this topup.")
    status: Optional[StrictStr] = Field(default=None, description="Status of the topup <table>   <thead>     <tr>       <th>         Status       </th>       <th>         Description       </th>     </tr>   </thead>   <tbody>     <tr>       <td>         <code>           created         </code>       </td>       <td>         The topup is processing (and may be under review).       </td>     </tr>     <tr>       <td>         <code>           fully_credited         </code>       </td>       <td>         The funds have been added to the balance.       </td>     </tr>     <tr>       <td>         <code>           reversed         </code>       </td>       <td>         The topup was credited, but then reversed due to a chargeback or ACH return.       </td>     </tr>     <tr>       <td>         <code>           rejected         </code>       </td>       <td>         The topup was rejected by an admin.       </td>     </tr>   </tbody> </table> ")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the topup object was created (when the request was made).")
    fully_credited_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the topup amount was fully credited to the balance.")
    rejected_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the topup was rejected.")
    reversed_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the topup was reversed.")
    reversed_reason: Optional[StrictStr] = Field(default=None, description="A sentence explaining why the topup was reversed.")
    idempotency_key: Optional[StrictStr] = Field(default=None, description="Idempotency key to prevent duplicate requests.")
    __properties: ClassVar[List[str]] = ["id", "amount", "processing_fee", "funding_source_id", "status", "created_at", "fully_credited_at", "rejected_at", "reversed_at", "reversed_reason", "idempotency_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListTopups200ResponseTopupsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if fully_credited_at (nullable) is None
        # and model_fields_set contains the field
        if self.fully_credited_at is None and "fully_credited_at" in self.model_fields_set:
            _dict['fully_credited_at'] = None

        # set to None if rejected_at (nullable) is None
        # and model_fields_set contains the field
        if self.rejected_at is None and "rejected_at" in self.model_fields_set:
            _dict['rejected_at'] = None

        # set to None if reversed_at (nullable) is None
        # and model_fields_set contains the field
        if self.reversed_at is None and "reversed_at" in self.model_fields_set:
            _dict['reversed_at'] = None

        # set to None if reversed_reason (nullable) is None
        # and model_fields_set contains the field
        if self.reversed_reason is None and "reversed_reason" in self.model_fields_set:
            _dict['reversed_reason'] = None

        # set to None if idempotency_key (nullable) is None
        # and model_fields_set contains the field
        if self.idempotency_key is None and "idempotency_key" in self.model_fields_set:
            _dict['idempotency_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListTopups200ResponseTopupsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "amount": obj.get("amount"),
            "processing_fee": obj.get("processing_fee"),
            "funding_source_id": obj.get("funding_source_id"),
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "fully_credited_at": obj.get("fully_credited_at"),
            "rejected_at": obj.get("rejected_at"),
            "reversed_at": obj.get("reversed_at"),
            "reversed_reason": obj.get("reversed_reason"),
            "idempotency_key": obj.get("idempotency_key")
        })
        return _obj


