# coding: utf-8

"""
    trieve-server

    Trieve REST API OpenAPI Documentation

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ClientDatasetConfiguration(BaseModel):
    """
    ClientDatasetConfiguration
    """ # noqa: E501
    create_chunk_feature: Optional[StrictBool] = Field(default=None, alias="CREATE_CHUNK_FEATURE")
    date_range_value: Optional[StrictStr] = Field(default=None, alias="DATE_RANGE_VALUE")
    document_upload_feature: Optional[StrictBool] = Field(default=None, alias="DOCUMENT_UPLOAD_FEATURE")
    filter_items: Optional[Any] = Field(default=None, alias="FILTER_ITEMS")
    frontmatter_vals: Optional[StrictStr] = Field(default=None, alias="FRONTMATTER_VALS")
    image_range_end_key: Optional[StrictStr] = Field(default=None, alias="IMAGE_RANGE_END_KEY")
    image_range_start_key: Optional[StrictStr] = Field(default=None, alias="IMAGE_RANGE_START_KEY")
    lines_before_show_more: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, alias="LINES_BEFORE_SHOW_MORE")
    search_queries: Optional[StrictStr] = Field(default=None, alias="SEARCH_QUERIES")
    show_github_stars: Optional[StrictBool] = Field(default=None, alias="SHOW_GITHUB_STARS")
    suggested_queries: Optional[StrictStr] = Field(default=None, alias="SUGGESTED_QUERIES")
    __properties: ClassVar[List[str]] = ["CREATE_CHUNK_FEATURE", "DATE_RANGE_VALUE", "DOCUMENT_UPLOAD_FEATURE", "FILTER_ITEMS", "FRONTMATTER_VALS", "IMAGE_RANGE_END_KEY", "IMAGE_RANGE_START_KEY", "LINES_BEFORE_SHOW_MORE", "SEARCH_QUERIES", "SHOW_GITHUB_STARS", "SUGGESTED_QUERIES"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ClientDatasetConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if create_chunk_feature (nullable) is None
        # and model_fields_set contains the field
        if self.create_chunk_feature is None and "create_chunk_feature" in self.model_fields_set:
            _dict['CREATE_CHUNK_FEATURE'] = None

        # set to None if date_range_value (nullable) is None
        # and model_fields_set contains the field
        if self.date_range_value is None and "date_range_value" in self.model_fields_set:
            _dict['DATE_RANGE_VALUE'] = None

        # set to None if document_upload_feature (nullable) is None
        # and model_fields_set contains the field
        if self.document_upload_feature is None and "document_upload_feature" in self.model_fields_set:
            _dict['DOCUMENT_UPLOAD_FEATURE'] = None

        # set to None if filter_items (nullable) is None
        # and model_fields_set contains the field
        if self.filter_items is None and "filter_items" in self.model_fields_set:
            _dict['FILTER_ITEMS'] = None

        # set to None if frontmatter_vals (nullable) is None
        # and model_fields_set contains the field
        if self.frontmatter_vals is None and "frontmatter_vals" in self.model_fields_set:
            _dict['FRONTMATTER_VALS'] = None

        # set to None if image_range_end_key (nullable) is None
        # and model_fields_set contains the field
        if self.image_range_end_key is None and "image_range_end_key" in self.model_fields_set:
            _dict['IMAGE_RANGE_END_KEY'] = None

        # set to None if image_range_start_key (nullable) is None
        # and model_fields_set contains the field
        if self.image_range_start_key is None and "image_range_start_key" in self.model_fields_set:
            _dict['IMAGE_RANGE_START_KEY'] = None

        # set to None if lines_before_show_more (nullable) is None
        # and model_fields_set contains the field
        if self.lines_before_show_more is None and "lines_before_show_more" in self.model_fields_set:
            _dict['LINES_BEFORE_SHOW_MORE'] = None

        # set to None if search_queries (nullable) is None
        # and model_fields_set contains the field
        if self.search_queries is None and "search_queries" in self.model_fields_set:
            _dict['SEARCH_QUERIES'] = None

        # set to None if show_github_stars (nullable) is None
        # and model_fields_set contains the field
        if self.show_github_stars is None and "show_github_stars" in self.model_fields_set:
            _dict['SHOW_GITHUB_STARS'] = None

        # set to None if suggested_queries (nullable) is None
        # and model_fields_set contains the field
        if self.suggested_queries is None and "suggested_queries" in self.model_fields_set:
            _dict['SUGGESTED_QUERIES'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ClientDatasetConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CREATE_CHUNK_FEATURE": obj.get("CREATE_CHUNK_FEATURE"),
            "DATE_RANGE_VALUE": obj.get("DATE_RANGE_VALUE"),
            "DOCUMENT_UPLOAD_FEATURE": obj.get("DOCUMENT_UPLOAD_FEATURE"),
            "FILTER_ITEMS": obj.get("FILTER_ITEMS"),
            "FRONTMATTER_VALS": obj.get("FRONTMATTER_VALS"),
            "IMAGE_RANGE_END_KEY": obj.get("IMAGE_RANGE_END_KEY"),
            "IMAGE_RANGE_START_KEY": obj.get("IMAGE_RANGE_START_KEY"),
            "LINES_BEFORE_SHOW_MORE": obj.get("LINES_BEFORE_SHOW_MORE"),
            "SEARCH_QUERIES": obj.get("SEARCH_QUERIES"),
            "SHOW_GITHUB_STARS": obj.get("SHOW_GITHUB_STARS"),
            "SUGGESTED_QUERIES": obj.get("SUGGESTED_QUERIES")
        })
        return _obj


