# coding: utf-8

"""
    trieve-server

    Trieve REST API OpenAPI Documentation

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CreateChunkData(BaseModel):
    """
    CreateChunkData
    """ # noqa: E501
    chunk_html: Optional[StrictStr] = Field(default=None, description="HTML content of the chunk. This can also be plaintext. The innerText of the HTML will be used to create the embedding vector. The point of using HTML is for convienience, as some users have applications where users submit HTML content.")
    chunk_vector: Optional[List[Union[StrictFloat, StrictInt]]] = Field(default=None, description="Chunk_vector is a vector of floats which can be used instead of generating a new embedding. This is useful for when you are using a pre-embedded dataset. If this is not provided, the innerText of the chunk_html will be used to create the embedding.")
    collection_id: Optional[StrictStr] = Field(default=None, description="Collection_id is the id of the collection that the chunk should be placed into. This is useful for when you want to create a chunk and add it to a collection in one request.")
    file_uuid: Optional[StrictStr] = Field(default=None, description="File_uuid is the uuid of the file that the chunk is associated with. This is used to associate chunks with files. This is useful for when you want to delete a file and all of its associated chunks.")
    link: Optional[StrictStr] = Field(default=None, description="Link to the chunk. This can also be any string. Frequently, this is a link to the source of the chunk. The link value will not affect the embedding creation.")
    metadata: Optional[Any] = Field(default=None, description="Metadata is a JSON object which can be used to filter chunks. This is useful for when you want to filter chunks by arbitrary metadata. Unlike with tag filtering, there is a performance hit for filtering on metadata.")
    tag_set: Optional[StrictStr] = Field(default=None, description="Tag set is a comma separated list of tags. This can be used to filter chunks by tag. Unlike with metadata filtering, HNSW indices will exist for each tag such that there is not a performance hit for filtering on them.")
    time_stamp: Optional[StrictStr] = Field(default=None, description="Time_stamp should be an ISO 8601 combined date and time without timezone. It is used for time window filtering and recency-biasing search results.")
    tracking_id: Optional[StrictStr] = Field(default=None, description="Tracking_id is a string which can be used to identify a chunk. This is useful for when you are coordinating with an external system and want to use the tracking_id to identify the chunk.")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Weight is a float which can be used to bias search results. This is useful for when you want to bias search results for a chunk. The magnitude only matters relative to other chunks in the chunk's dataset dataset.")
    __properties: ClassVar[List[str]] = ["chunk_html", "chunk_vector", "collection_id", "file_uuid", "link", "metadata", "tag_set", "time_stamp", "tracking_id", "weight"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateChunkData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if chunk_html (nullable) is None
        # and model_fields_set contains the field
        if self.chunk_html is None and "chunk_html" in self.model_fields_set:
            _dict['chunk_html'] = None

        # set to None if chunk_vector (nullable) is None
        # and model_fields_set contains the field
        if self.chunk_vector is None and "chunk_vector" in self.model_fields_set:
            _dict['chunk_vector'] = None

        # set to None if collection_id (nullable) is None
        # and model_fields_set contains the field
        if self.collection_id is None and "collection_id" in self.model_fields_set:
            _dict['collection_id'] = None

        # set to None if file_uuid (nullable) is None
        # and model_fields_set contains the field
        if self.file_uuid is None and "file_uuid" in self.model_fields_set:
            _dict['file_uuid'] = None

        # set to None if link (nullable) is None
        # and model_fields_set contains the field
        if self.link is None and "link" in self.model_fields_set:
            _dict['link'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if tag_set (nullable) is None
        # and model_fields_set contains the field
        if self.tag_set is None and "tag_set" in self.model_fields_set:
            _dict['tag_set'] = None

        # set to None if time_stamp (nullable) is None
        # and model_fields_set contains the field
        if self.time_stamp is None and "time_stamp" in self.model_fields_set:
            _dict['time_stamp'] = None

        # set to None if tracking_id (nullable) is None
        # and model_fields_set contains the field
        if self.tracking_id is None and "tracking_id" in self.model_fields_set:
            _dict['tracking_id'] = None

        # set to None if weight (nullable) is None
        # and model_fields_set contains the field
        if self.weight is None and "weight" in self.model_fields_set:
            _dict['weight'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateChunkData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chunk_html": obj.get("chunk_html"),
            "chunk_vector": obj.get("chunk_vector"),
            "collection_id": obj.get("collection_id"),
            "file_uuid": obj.get("file_uuid"),
            "link": obj.get("link"),
            "metadata": obj.get("metadata"),
            "tag_set": obj.get("tag_set"),
            "time_stamp": obj.get("time_stamp"),
            "tracking_id": obj.get("tracking_id"),
            "weight": obj.get("weight")
        })
        return _obj


