# coding: utf-8

"""
    trieve-server

    Trieve REST API OpenAPI Documentation

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trieve_python_client.models.chunk_metadata_with_file_data import ChunkMetadataWithFileData
from typing import Optional, Set
from typing_extensions import Self

class UserDTOWithChunks(BaseModel):
    """
    UserDTOWithChunks
    """ # noqa: E501
    chunks: List[ChunkMetadataWithFileData]
    created_at: datetime
    email: Optional[StrictStr] = None
    id: StrictStr
    total_chunks_created: StrictInt
    username: Optional[StrictStr] = None
    visible_email: StrictBool
    website: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["chunks", "created_at", "email", "id", "total_chunks_created", "username", "visible_email", "website"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserDTOWithChunks from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in chunks (list)
        _items = []
        if self.chunks:
            for _item in self.chunks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['chunks'] = _items
        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if website (nullable) is None
        # and model_fields_set contains the field
        if self.website is None and "website" in self.model_fields_set:
            _dict['website'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserDTOWithChunks from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chunks": [ChunkMetadataWithFileData.from_dict(_item) for _item in obj["chunks"]] if obj.get("chunks") is not None else None,
            "created_at": obj.get("created_at"),
            "email": obj.get("email"),
            "id": obj.get("id"),
            "total_chunks_created": obj.get("total_chunks_created"),
            "username": obj.get("username"),
            "visible_email": obj.get("visible_email"),
            "website": obj.get("website")
        })
        return _obj


