---
hide:
  - navigation
  - toc
---

# tuto-python-setup-package

<p align="center">
  <strong>Tutorial package for Python setup workflow</strong>
</p>

<p align="center">
  <a href="https://github.com/JarryGabriel/tuto-python-setup-package/actions/workflows/ci.yml">
    <img src="https://github.com/JarryGabriel/tuto-python-setup-package/actions/workflows/ci.yml/badge.svg" alt="CI" />
  </a>
  <a href="https://coveralls.io/github/JarryGabriel/tuto-python-setup-package?branch=main">
    <img src="https://coveralls.io/repos/github/JarryGabriel/tuto-python-setup-package/badge.svg?branch=main" alt="Coverage" />
  </a>
  <a href="https://pypi.org/project/tuto-python-setup-package/">
    <img src="https://img.shields.io/pypi/v/tuto-python-setup-package" alt="PyPI" />
  </a>
  <img src="https://img.shields.io/badge/python-3.12+-blue.svg" alt="Python 3.12+" />
  <img src="https://img.shields.io/badge/typed-strict-blue.svg" alt="Typed" />
</p>

---

## Installation

```bash
uv add tuto-python-setup-package
```

## Quick Start

```python
from tuto_python_setup_package import hello

print(hello())
```

## Features

- ✅ **Modern Python** — 3.12+ with strict typing
- ✅ **Fast** — Optimized for performance  
- ✅ **Tested** — Full coverage with pytest

---

<div style="text-align: center; margin: 2rem 0;">
  <a href="getting-started/" class="md-button md-button--primary">Get Started →</a>
</div>
