This project is a branch of [Twisted](https://pypi.org/project/Twisted/) on [QPython](https://www.qpython.org).

Twisted is an MIT-licensed open source project with its ongoing development made possible entirely by the support of the community and these awesome sponsors. If you'd like to join them, please consider [sponsoring Twisted's development](https://docs.twisted.org/en/latest/development/sponsorship.html).

---

### What is this?

Twisted is a **Python event-based framework for internet applications**. It includes modules for many different purposes, including the following:

* `twisted.web`: HTTP clients and servers, HTML templating, and a WSGI server
* `twisted.conch`: SSHv2 and Telnet clients and servers and terminal emulators
* `twisted.words`: Clients and servers for IRC, XMPP, and other IM protocols
* `twisted.mail`: IMAPv4, POP3, SMTP clients and servers
* `twisted.positioning`: Tools for communicating with NMEA-compatible GPS receivers
* `twisted.names`: DNS client and tools for making your own DNS servers
* `twisted.trial`: A unit testing framework that integrates well with Twisted-based code.

Twisted supports all major system event loops—`select` (all platforms), `poll` (most POSIX platforms), `epoll` (Linux), `kqueue` (FreeBSD, macOS), IOCP (Windows), and various GUI event loops (GTK+2/3, Qt, wxWidgets). Third-party reactors can plug into Twisted and provide support for additional event loops.

---

### Installing

To install the latest version of Twisted using pip:

```bash
pip install twisted-qpython
```

Additional instructions for installing this software are in [the installation instructions](https://docs.twisted.org/en/latest/installation.html).

---

### Documentation and Support

Twisted's documentation is available from the [Twisted Matrix Read The Docs website](https://docs.twisted.org/). This documentation contains how-tos, code examples, and an API reference.

Help is also available on the [Twisted mailing list](https://mail.python.org/mailman3/lists/twisted.python.org/).

There is also an IRC channel, `#twisted`, on the [Libera.Chat](https://libera.chat/) network. A web client is available at [web.libera.chat](https://web.libera.chat/).

---

### Unit Tests

Twisted has a comprehensive test suite, which can be run by `tox`:

```bash
tox -l                       # to view all test environments
tox -e nocov                 # to run all the tests without coverage
tox -e withcov               # to run all the tests with coverage
tox -e alldeps-withcov-posix # install all dependencies, run tests with coverage on POSIX platform
```

You can test running the test suite under the different reactors with the `TWISTED_REACTOR` environment variable:

```bash
env TWISTED_REACTOR=epoll tox -e alldeps-withcov-posix
```

Some of these tests may fail if you:

* don't have the dependencies required for a particular subsystem installed,
* have a firewall blocking some ports (or things like Multicast, which Linux NAT has shown itself to do), or
* run them as root.