# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic import BaseModel, Field
from twitter_openapi_python_generated.models.item_content_union import ItemContentUnion

class ModuleEntry(BaseModel):
    """
    ModuleEntry
    """
    client_event_info: Dict[str, Any] = Field(..., alias="clientEventInfo")
    item_content: ItemContentUnion = Field(..., alias="itemContent")
    __properties = ["clientEventInfo", "itemContent"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModuleEntry:
        """Create an instance of ModuleEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of item_content
        if self.item_content:
            _dict['itemContent'] = self.item_content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModuleEntry:
        """Create an instance of ModuleEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModuleEntry.parse_obj(obj)

        _obj = ModuleEntry.parse_obj({
            "client_event_info": obj.get("clientEventInfo"),
            "item_content": ItemContentUnion.from_dict(obj.get("itemContent")) if obj.get("itemContent") is not None else None
        })
        return _obj


