# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist
from twitter_openapi_python_generated.models.tweet_card_legacy_binding_values_inner import TweetCardLegacyBindingValuesInner

class TweetCardLegacy(BaseModel):
    """
    TweetCardLegacy
    """
    binding_values: conlist(TweetCardLegacyBindingValuesInner) = Field(...)
    name: StrictStr = Field(...)
    url: StrictStr = Field(...)
    __properties = ["binding_values", "name", "url"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TweetCardLegacy:
        """Create an instance of TweetCardLegacy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in binding_values (list)
        _items = []
        if self.binding_values:
            for _item in self.binding_values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['binding_values'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TweetCardLegacy:
        """Create an instance of TweetCardLegacy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TweetCardLegacy.parse_obj(obj)

        _obj = TweetCardLegacy.parse_obj({
            "binding_values": [TweetCardLegacyBindingValuesInner.from_dict(_item) for _item in obj.get("binding_values")] if obj.get("binding_values") is not None else None,
            "name": obj.get("name"),
            "url": obj.get("url")
        })
        return _obj


