# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, constr, validator
from twitter_openapi_python_generated.models.entities import Entities
from twitter_openapi_python_generated.models.extended_entities import ExtendedEntities
from twitter_openapi_python_generated.models.tweet_legacy_self_thread import TweetLegacySelfThread

class TweetLegacy(BaseModel):
    """
    TweetLegacy
    """
    bookmark_count: StrictInt = Field(...)
    bookmarked: StrictBool = Field(...)
    conversation_id_str: constr(strict=True) = Field(...)
    created_at: constr(strict=True) = Field(...)
    display_text_range: conlist(StrictInt) = Field(...)
    entities: Entities = Field(...)
    extended_entities: Optional[ExtendedEntities] = None
    favorite_count: StrictInt = Field(...)
    favorited: StrictBool = Field(...)
    full_text: StrictStr = Field(...)
    id_str: constr(strict=True) = Field(...)
    is_quote_status: StrictBool = Field(...)
    lang: StrictStr = Field(...)
    possibly_sensitive: Optional[StrictBool] = False
    possibly_sensitive_editable: Optional[StrictBool] = False
    quote_count: StrictInt = Field(...)
    reply_count: StrictInt = Field(...)
    retweet_count: StrictInt = Field(...)
    retweeted: StrictBool = Field(...)
    retweeted_status_result: Optional[ItemResult] = None
    self_thread: Optional[TweetLegacySelfThread] = None
    user_id_str: constr(strict=True) = Field(...)
    __properties = ["bookmark_count", "bookmarked", "conversation_id_str", "created_at", "display_text_range", "entities", "extended_entities", "favorite_count", "favorited", "full_text", "id_str", "is_quote_status", "lang", "possibly_sensitive", "possibly_sensitive_editable", "quote_count", "reply_count", "retweet_count", "retweeted", "retweeted_status_result", "self_thread", "user_id_str"]

    @validator('conversation_id_str')
    def conversation_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @validator('created_at')
    def created_at_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(Sun|Mon|Tue|Wed|Thu|Fri|Sat) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (0[1-9]|[12][0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]) ([+-][0-9]{4}) ([0-9]{4})$", value):
            raise ValueError(r"must validate the regular expression /^(Sun|Mon|Tue|Wed|Thu|Fri|Sat) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (0[1-9]|[12][0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]) ([+-][0-9]{4}) ([0-9]{4})$/")
        return value

    @validator('id_str')
    def id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @validator('user_id_str')
    def user_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TweetLegacy:
        """Create an instance of TweetLegacy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of entities
        if self.entities:
            _dict['entities'] = self.entities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extended_entities
        if self.extended_entities:
            _dict['extended_entities'] = self.extended_entities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of retweeted_status_result
        if self.retweeted_status_result:
            _dict['retweeted_status_result'] = self.retweeted_status_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of self_thread
        if self.self_thread:
            _dict['self_thread'] = self.self_thread.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TweetLegacy:
        """Create an instance of TweetLegacy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TweetLegacy.parse_obj(obj)

        _obj = TweetLegacy.parse_obj({
            "bookmark_count": obj.get("bookmark_count"),
            "bookmarked": obj.get("bookmarked"),
            "conversation_id_str": obj.get("conversation_id_str"),
            "created_at": obj.get("created_at"),
            "display_text_range": obj.get("display_text_range"),
            "entities": Entities.from_dict(obj.get("entities")) if obj.get("entities") is not None else None,
            "extended_entities": ExtendedEntities.from_dict(obj.get("extended_entities")) if obj.get("extended_entities") is not None else None,
            "favorite_count": obj.get("favorite_count"),
            "favorited": obj.get("favorited"),
            "full_text": obj.get("full_text"),
            "id_str": obj.get("id_str"),
            "is_quote_status": obj.get("is_quote_status"),
            "lang": obj.get("lang"),
            "possibly_sensitive": obj.get("possibly_sensitive") if obj.get("possibly_sensitive") is not None else False,
            "possibly_sensitive_editable": obj.get("possibly_sensitive_editable") if obj.get("possibly_sensitive_editable") is not None else False,
            "quote_count": obj.get("quote_count"),
            "reply_count": obj.get("reply_count"),
            "retweet_count": obj.get("retweet_count"),
            "retweeted": obj.get("retweeted"),
            "retweeted_status_result": ItemResult.from_dict(obj.get("retweeted_status_result")) if obj.get("retweeted_status_result") is not None else None,
            "self_thread": TweetLegacySelfThread.from_dict(obj.get("self_thread")) if obj.get("self_thread") is not None else None,
            "user_id_str": obj.get("user_id_str")
        })
        return _obj

from twitter_openapi_python_generated.models.item_result import ItemResult
TweetLegacy.update_forward_refs()

