# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictBool, StrictInt, StrictStr

from twitter_openapi_python_generated.api_client import ApiClient, RequestSerialized
from twitter_openapi_python_generated.api_response import ApiResponse
from twitter_openapi_python_generated.rest import RESTResponseType


class V20GetApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_search_adaptive(
        self,
        include_profile_interstitial_type: StrictInt,
        include_blocking: StrictInt,
        include_blocked_by: StrictInt,
        include_followed_by: StrictInt,
        include_want_retweets: StrictInt,
        include_mute_edge: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        skip_status: StrictInt,
        cards_platform: StrictStr,
        include_cards: StrictInt,
        include_ext_alt_text: StrictBool,
        include_ext_limited_action_results: StrictBool,
        include_quote_count: StrictBool,
        include_reply_count: StrictInt,
        tweet_mode: StrictStr,
        include_ext_views: StrictBool,
        include_entities: StrictBool,
        include_user_entities: StrictBool,
        include_ext_media_color: StrictBool,
        include_ext_media_availability: StrictBool,
        include_ext_sensitive_media_warning: StrictBool,
        include_ext_trusted_friends_metadata: StrictBool,
        send_error_codes: StrictBool,
        simple_quoted_tweet: StrictBool,
        q: StrictStr,
        query_source: StrictStr,
        count: StrictInt,
        request_context: StrictStr,
        pc: StrictInt,
        spelling_corrections: StrictInt,
        include_ext_edit_control: StrictBool,
        ext: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """get_search_adaptive

        get search adaptive

        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param skip_status: (required)
        :type skip_status: int
        :param cards_platform: (required)
        :type cards_platform: str
        :param include_cards: (required)
        :type include_cards: int
        :param include_ext_alt_text: (required)
        :type include_ext_alt_text: bool
        :param include_ext_limited_action_results: (required)
        :type include_ext_limited_action_results: bool
        :param include_quote_count: (required)
        :type include_quote_count: bool
        :param include_reply_count: (required)
        :type include_reply_count: int
        :param tweet_mode: (required)
        :type tweet_mode: str
        :param include_ext_views: (required)
        :type include_ext_views: bool
        :param include_entities: (required)
        :type include_entities: bool
        :param include_user_entities: (required)
        :type include_user_entities: bool
        :param include_ext_media_color: (required)
        :type include_ext_media_color: bool
        :param include_ext_media_availability: (required)
        :type include_ext_media_availability: bool
        :param include_ext_sensitive_media_warning: (required)
        :type include_ext_sensitive_media_warning: bool
        :param include_ext_trusted_friends_metadata: (required)
        :type include_ext_trusted_friends_metadata: bool
        :param send_error_codes: (required)
        :type send_error_codes: bool
        :param simple_quoted_tweet: (required)
        :type simple_quoted_tweet: bool
        :param q: (required)
        :type q: str
        :param query_source: (required)
        :type query_source: str
        :param count: (required)
        :type count: int
        :param request_context: (required)
        :type request_context: str
        :param pc: (required)
        :type pc: int
        :param spelling_corrections: (required)
        :type spelling_corrections: int
        :param include_ext_edit_control: (required)
        :type include_ext_edit_control: bool
        :param ext: (required)
        :type ext: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_adaptive_serialize(
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_blocking=include_blocking,
            include_blocked_by=include_blocked_by,
            include_followed_by=include_followed_by,
            include_want_retweets=include_want_retweets,
            include_mute_edge=include_mute_edge,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            skip_status=skip_status,
            cards_platform=cards_platform,
            include_cards=include_cards,
            include_ext_alt_text=include_ext_alt_text,
            include_ext_limited_action_results=include_ext_limited_action_results,
            include_quote_count=include_quote_count,
            include_reply_count=include_reply_count,
            tweet_mode=tweet_mode,
            include_ext_views=include_ext_views,
            include_entities=include_entities,
            include_user_entities=include_user_entities,
            include_ext_media_color=include_ext_media_color,
            include_ext_media_availability=include_ext_media_availability,
            include_ext_sensitive_media_warning=include_ext_sensitive_media_warning,
            include_ext_trusted_friends_metadata=include_ext_trusted_friends_metadata,
            send_error_codes=send_error_codes,
            simple_quoted_tweet=simple_quoted_tweet,
            q=q,
            query_source=query_source,
            count=count,
            request_context=request_context,
            pc=pc,
            spelling_corrections=spelling_corrections,
            include_ext_edit_control=include_ext_edit_control,
            ext=ext,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_search_adaptive_with_http_info(
        self,
        include_profile_interstitial_type: StrictInt,
        include_blocking: StrictInt,
        include_blocked_by: StrictInt,
        include_followed_by: StrictInt,
        include_want_retweets: StrictInt,
        include_mute_edge: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        skip_status: StrictInt,
        cards_platform: StrictStr,
        include_cards: StrictInt,
        include_ext_alt_text: StrictBool,
        include_ext_limited_action_results: StrictBool,
        include_quote_count: StrictBool,
        include_reply_count: StrictInt,
        tweet_mode: StrictStr,
        include_ext_views: StrictBool,
        include_entities: StrictBool,
        include_user_entities: StrictBool,
        include_ext_media_color: StrictBool,
        include_ext_media_availability: StrictBool,
        include_ext_sensitive_media_warning: StrictBool,
        include_ext_trusted_friends_metadata: StrictBool,
        send_error_codes: StrictBool,
        simple_quoted_tweet: StrictBool,
        q: StrictStr,
        query_source: StrictStr,
        count: StrictInt,
        request_context: StrictStr,
        pc: StrictInt,
        spelling_corrections: StrictInt,
        include_ext_edit_control: StrictBool,
        ext: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """get_search_adaptive

        get search adaptive

        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param skip_status: (required)
        :type skip_status: int
        :param cards_platform: (required)
        :type cards_platform: str
        :param include_cards: (required)
        :type include_cards: int
        :param include_ext_alt_text: (required)
        :type include_ext_alt_text: bool
        :param include_ext_limited_action_results: (required)
        :type include_ext_limited_action_results: bool
        :param include_quote_count: (required)
        :type include_quote_count: bool
        :param include_reply_count: (required)
        :type include_reply_count: int
        :param tweet_mode: (required)
        :type tweet_mode: str
        :param include_ext_views: (required)
        :type include_ext_views: bool
        :param include_entities: (required)
        :type include_entities: bool
        :param include_user_entities: (required)
        :type include_user_entities: bool
        :param include_ext_media_color: (required)
        :type include_ext_media_color: bool
        :param include_ext_media_availability: (required)
        :type include_ext_media_availability: bool
        :param include_ext_sensitive_media_warning: (required)
        :type include_ext_sensitive_media_warning: bool
        :param include_ext_trusted_friends_metadata: (required)
        :type include_ext_trusted_friends_metadata: bool
        :param send_error_codes: (required)
        :type send_error_codes: bool
        :param simple_quoted_tweet: (required)
        :type simple_quoted_tweet: bool
        :param q: (required)
        :type q: str
        :param query_source: (required)
        :type query_source: str
        :param count: (required)
        :type count: int
        :param request_context: (required)
        :type request_context: str
        :param pc: (required)
        :type pc: int
        :param spelling_corrections: (required)
        :type spelling_corrections: int
        :param include_ext_edit_control: (required)
        :type include_ext_edit_control: bool
        :param ext: (required)
        :type ext: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_adaptive_serialize(
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_blocking=include_blocking,
            include_blocked_by=include_blocked_by,
            include_followed_by=include_followed_by,
            include_want_retweets=include_want_retweets,
            include_mute_edge=include_mute_edge,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            skip_status=skip_status,
            cards_platform=cards_platform,
            include_cards=include_cards,
            include_ext_alt_text=include_ext_alt_text,
            include_ext_limited_action_results=include_ext_limited_action_results,
            include_quote_count=include_quote_count,
            include_reply_count=include_reply_count,
            tweet_mode=tweet_mode,
            include_ext_views=include_ext_views,
            include_entities=include_entities,
            include_user_entities=include_user_entities,
            include_ext_media_color=include_ext_media_color,
            include_ext_media_availability=include_ext_media_availability,
            include_ext_sensitive_media_warning=include_ext_sensitive_media_warning,
            include_ext_trusted_friends_metadata=include_ext_trusted_friends_metadata,
            send_error_codes=send_error_codes,
            simple_quoted_tweet=simple_quoted_tweet,
            q=q,
            query_source=query_source,
            count=count,
            request_context=request_context,
            pc=pc,
            spelling_corrections=spelling_corrections,
            include_ext_edit_control=include_ext_edit_control,
            ext=ext,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_search_adaptive_without_preload_content(
        self,
        include_profile_interstitial_type: StrictInt,
        include_blocking: StrictInt,
        include_blocked_by: StrictInt,
        include_followed_by: StrictInt,
        include_want_retweets: StrictInt,
        include_mute_edge: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        skip_status: StrictInt,
        cards_platform: StrictStr,
        include_cards: StrictInt,
        include_ext_alt_text: StrictBool,
        include_ext_limited_action_results: StrictBool,
        include_quote_count: StrictBool,
        include_reply_count: StrictInt,
        tweet_mode: StrictStr,
        include_ext_views: StrictBool,
        include_entities: StrictBool,
        include_user_entities: StrictBool,
        include_ext_media_color: StrictBool,
        include_ext_media_availability: StrictBool,
        include_ext_sensitive_media_warning: StrictBool,
        include_ext_trusted_friends_metadata: StrictBool,
        send_error_codes: StrictBool,
        simple_quoted_tweet: StrictBool,
        q: StrictStr,
        query_source: StrictStr,
        count: StrictInt,
        request_context: StrictStr,
        pc: StrictInt,
        spelling_corrections: StrictInt,
        include_ext_edit_control: StrictBool,
        ext: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_search_adaptive

        get search adaptive

        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param skip_status: (required)
        :type skip_status: int
        :param cards_platform: (required)
        :type cards_platform: str
        :param include_cards: (required)
        :type include_cards: int
        :param include_ext_alt_text: (required)
        :type include_ext_alt_text: bool
        :param include_ext_limited_action_results: (required)
        :type include_ext_limited_action_results: bool
        :param include_quote_count: (required)
        :type include_quote_count: bool
        :param include_reply_count: (required)
        :type include_reply_count: int
        :param tweet_mode: (required)
        :type tweet_mode: str
        :param include_ext_views: (required)
        :type include_ext_views: bool
        :param include_entities: (required)
        :type include_entities: bool
        :param include_user_entities: (required)
        :type include_user_entities: bool
        :param include_ext_media_color: (required)
        :type include_ext_media_color: bool
        :param include_ext_media_availability: (required)
        :type include_ext_media_availability: bool
        :param include_ext_sensitive_media_warning: (required)
        :type include_ext_sensitive_media_warning: bool
        :param include_ext_trusted_friends_metadata: (required)
        :type include_ext_trusted_friends_metadata: bool
        :param send_error_codes: (required)
        :type send_error_codes: bool
        :param simple_quoted_tweet: (required)
        :type simple_quoted_tweet: bool
        :param q: (required)
        :type q: str
        :param query_source: (required)
        :type query_source: str
        :param count: (required)
        :type count: int
        :param request_context: (required)
        :type request_context: str
        :param pc: (required)
        :type pc: int
        :param spelling_corrections: (required)
        :type spelling_corrections: int
        :param include_ext_edit_control: (required)
        :type include_ext_edit_control: bool
        :param ext: (required)
        :type ext: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_adaptive_serialize(
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_blocking=include_blocking,
            include_blocked_by=include_blocked_by,
            include_followed_by=include_followed_by,
            include_want_retweets=include_want_retweets,
            include_mute_edge=include_mute_edge,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            skip_status=skip_status,
            cards_platform=cards_platform,
            include_cards=include_cards,
            include_ext_alt_text=include_ext_alt_text,
            include_ext_limited_action_results=include_ext_limited_action_results,
            include_quote_count=include_quote_count,
            include_reply_count=include_reply_count,
            tweet_mode=tweet_mode,
            include_ext_views=include_ext_views,
            include_entities=include_entities,
            include_user_entities=include_user_entities,
            include_ext_media_color=include_ext_media_color,
            include_ext_media_availability=include_ext_media_availability,
            include_ext_sensitive_media_warning=include_ext_sensitive_media_warning,
            include_ext_trusted_friends_metadata=include_ext_trusted_friends_metadata,
            send_error_codes=send_error_codes,
            simple_quoted_tweet=simple_quoted_tweet,
            q=q,
            query_source=query_source,
            count=count,
            request_context=request_context,
            pc=pc,
            spelling_corrections=spelling_corrections,
            include_ext_edit_control=include_ext_edit_control,
            ext=ext,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_search_adaptive_serialize(
        self,
        include_profile_interstitial_type,
        include_blocking,
        include_blocked_by,
        include_followed_by,
        include_want_retweets,
        include_mute_edge,
        include_can_dm,
        include_can_media_tag,
        include_ext_has_nft_avatar,
        include_ext_is_blue_verified,
        include_ext_verified_type,
        include_ext_profile_image_shape,
        skip_status,
        cards_platform,
        include_cards,
        include_ext_alt_text,
        include_ext_limited_action_results,
        include_quote_count,
        include_reply_count,
        tweet_mode,
        include_ext_views,
        include_entities,
        include_user_entities,
        include_ext_media_color,
        include_ext_media_availability,
        include_ext_sensitive_media_warning,
        include_ext_trusted_friends_metadata,
        send_error_codes,
        simple_quoted_tweet,
        q,
        query_source,
        count,
        request_context,
        pc,
        spelling_corrections,
        include_ext_edit_control,
        ext,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include_profile_interstitial_type is not None:
            
            _query_params.append(('include_profile_interstitial_type', include_profile_interstitial_type))
            
        if include_blocking is not None:
            
            _query_params.append(('include_blocking', include_blocking))
            
        if include_blocked_by is not None:
            
            _query_params.append(('include_blocked_by', include_blocked_by))
            
        if include_followed_by is not None:
            
            _query_params.append(('include_followed_by', include_followed_by))
            
        if include_want_retweets is not None:
            
            _query_params.append(('include_want_retweets', include_want_retweets))
            
        if include_mute_edge is not None:
            
            _query_params.append(('include_mute_edge', include_mute_edge))
            
        if include_can_dm is not None:
            
            _query_params.append(('include_can_dm', include_can_dm))
            
        if include_can_media_tag is not None:
            
            _query_params.append(('include_can_media_tag', include_can_media_tag))
            
        if include_ext_has_nft_avatar is not None:
            
            _query_params.append(('include_ext_has_nft_avatar', include_ext_has_nft_avatar))
            
        if include_ext_is_blue_verified is not None:
            
            _query_params.append(('include_ext_is_blue_verified', include_ext_is_blue_verified))
            
        if include_ext_verified_type is not None:
            
            _query_params.append(('include_ext_verified_type', include_ext_verified_type))
            
        if include_ext_profile_image_shape is not None:
            
            _query_params.append(('include_ext_profile_image_shape', include_ext_profile_image_shape))
            
        if skip_status is not None:
            
            _query_params.append(('skip_status', skip_status))
            
        if cards_platform is not None:
            
            _query_params.append(('cards_platform', cards_platform))
            
        if include_cards is not None:
            
            _query_params.append(('include_cards', include_cards))
            
        if include_ext_alt_text is not None:
            
            _query_params.append(('include_ext_alt_text', include_ext_alt_text))
            
        if include_ext_limited_action_results is not None:
            
            _query_params.append(('include_ext_limited_action_results', include_ext_limited_action_results))
            
        if include_quote_count is not None:
            
            _query_params.append(('include_quote_count', include_quote_count))
            
        if include_reply_count is not None:
            
            _query_params.append(('include_reply_count', include_reply_count))
            
        if tweet_mode is not None:
            
            _query_params.append(('tweet_mode', tweet_mode))
            
        if include_ext_views is not None:
            
            _query_params.append(('include_ext_views', include_ext_views))
            
        if include_entities is not None:
            
            _query_params.append(('include_entities', include_entities))
            
        if include_user_entities is not None:
            
            _query_params.append(('include_user_entities', include_user_entities))
            
        if include_ext_media_color is not None:
            
            _query_params.append(('include_ext_media_color', include_ext_media_color))
            
        if include_ext_media_availability is not None:
            
            _query_params.append(('include_ext_media_availability', include_ext_media_availability))
            
        if include_ext_sensitive_media_warning is not None:
            
            _query_params.append(('include_ext_sensitive_media_warning', include_ext_sensitive_media_warning))
            
        if include_ext_trusted_friends_metadata is not None:
            
            _query_params.append(('include_ext_trusted_friends_metadata', include_ext_trusted_friends_metadata))
            
        if send_error_codes is not None:
            
            _query_params.append(('send_error_codes', send_error_codes))
            
        if simple_quoted_tweet is not None:
            
            _query_params.append(('simple_quoted_tweet', simple_quoted_tweet))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if query_source is not None:
            
            _query_params.append(('query_source', query_source))
            
        if count is not None:
            
            _query_params.append(('count', count))
            
        if request_context is not None:
            
            _query_params.append(('requestContext', request_context))
            
        if pc is not None:
            
            _query_params.append(('pc', pc))
            
        if spelling_corrections is not None:
            
            _query_params.append(('spelling_corrections', spelling_corrections))
            
        if include_ext_edit_control is not None:
            
            _query_params.append(('include_ext_edit_control', include_ext_edit_control))
            
        if ext is not None:
            
            _query_params.append(('ext', ext))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'ClientLanguage', 
            'Accept', 
            'SecFetchDest', 
            'Pragma', 
            'SecChUaPlatform', 
            'SecFetchMode', 
            'CsrfToken', 
            'GuestToken', 
            'BearerAuth', 
            'SecChUa', 
            'CookieCt0', 
            'ActiveUser', 
            'UserAgent', 
            'AcceptLanguage', 
            'SecFetchSite', 
            'CookieAuthToken', 
            'AuthType', 
            'CacheControl', 
            'SecChUaMobile', 
            'AcceptEncoding'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/2/search/adaptive.json',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


