# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from twitter_openapi_python_generated.models.timeline_timeline_cursor import TimelineTimelineCursor
from twitter_openapi_python_generated.models.timeline_timeline_item import TimelineTimelineItem
from twitter_openapi_python_generated.models.timeline_timeline_module import TimelineTimelineModule
from pydantic import StrictStr, Field
from typing import Union, List, Optional, Dict
from typing_extensions import Literal, Self

CONTENTUNION_ONE_OF_SCHEMAS = ["TimelineTimelineCursor", "TimelineTimelineItem", "TimelineTimelineModule"]

class ContentUnion(BaseModel):
    """
    ContentUnion
    """
    # data type: TimelineTimelineItem
    oneof_schema_1_validator: Optional[TimelineTimelineItem] = None
    # data type: TimelineTimelineModule
    oneof_schema_2_validator: Optional[TimelineTimelineModule] = None
    # data type: TimelineTimelineCursor
    oneof_schema_3_validator: Optional[TimelineTimelineCursor] = None
    actual_instance: Optional[Union[TimelineTimelineCursor, TimelineTimelineItem, TimelineTimelineModule]] = None
    one_of_schemas: List[str] = Field(default=Literal["TimelineTimelineCursor", "TimelineTimelineItem", "TimelineTimelineModule"])

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ContentUnion.model_construct()
        error_messages = []
        match = 0
        # validate data type: TimelineTimelineItem
        if not isinstance(v, TimelineTimelineItem):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TimelineTimelineItem`")
        else:
            match += 1
        # validate data type: TimelineTimelineModule
        if not isinstance(v, TimelineTimelineModule):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TimelineTimelineModule`")
        else:
            match += 1
        # validate data type: TimelineTimelineCursor
        if not isinstance(v, TimelineTimelineCursor):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TimelineTimelineCursor`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ContentUnion with oneOf schemas: TimelineTimelineCursor, TimelineTimelineItem, TimelineTimelineModule. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ContentUnion with oneOf schemas: TimelineTimelineCursor, TimelineTimelineItem, TimelineTimelineModule. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # use oneOf discriminator to lookup the data type
        _data_type = json.loads(json_str).get("entryType")
        if not _data_type:
            raise ValueError("Failed to lookup data type from the field `entryType` in the input.")

        # check if data type is `TimelineTimelineCursor`
        if _data_type == "TimelineTimelineCursor":
            instance.actual_instance = TimelineTimelineCursor.from_json(json_str)
            return instance

        # check if data type is `TimelineTimelineItem`
        if _data_type == "TimelineTimelineItem":
            instance.actual_instance = TimelineTimelineItem.from_json(json_str)
            return instance

        # check if data type is `TimelineTimelineModule`
        if _data_type == "TimelineTimelineModule":
            instance.actual_instance = TimelineTimelineModule.from_json(json_str)
            return instance

        # deserialize data into TimelineTimelineItem
        try:
            instance.actual_instance = TimelineTimelineItem.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TimelineTimelineModule
        try:
            instance.actual_instance = TimelineTimelineModule.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TimelineTimelineCursor
        try:
            instance.actual_instance = TimelineTimelineCursor.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ContentUnion with oneOf schemas: TimelineTimelineCursor, TimelineTimelineItem, TimelineTimelineModule. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ContentUnion with oneOf schemas: TimelineTimelineCursor, TimelineTimelineItem, TimelineTimelineModule. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], TimelineTimelineCursor, TimelineTimelineItem, TimelineTimelineModule]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


