# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from twitter_openapi_python_generated.models.tweet_card_legacy_binding_value import TweetCardLegacyBindingValue
from twitter_openapi_python_generated.models.tweet_card_platform_data import TweetCardPlatformData
from twitter_openapi_python_generated.models.user_results import UserResults
from typing import Optional, Set
from typing_extensions import Self

class TweetCardLegacy(BaseModel):
    """
    TweetCardLegacy
    """ # noqa: E501
    binding_values: List[TweetCardLegacyBindingValue]
    card_platform: Optional[TweetCardPlatformData] = None
    name: StrictStr
    url: StrictStr
    user_refs_results: Optional[List[UserResults]] = None
    __properties: ClassVar[List[str]] = ["binding_values", "card_platform", "name", "url", "user_refs_results"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TweetCardLegacy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in binding_values (list)
        _items = []
        if self.binding_values:
            for _item in self.binding_values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['binding_values'] = _items
        # override the default output from pydantic by calling `to_dict()` of card_platform
        if self.card_platform:
            _dict['card_platform'] = self.card_platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in user_refs_results (list)
        _items = []
        if self.user_refs_results:
            for _item in self.user_refs_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['user_refs_results'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TweetCardLegacy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "binding_values": [TweetCardLegacyBindingValue.from_dict(_item) for _item in obj["binding_values"]] if obj.get("binding_values") is not None else None,
            "card_platform": TweetCardPlatformData.from_dict(obj["card_platform"]) if obj.get("card_platform") is not None else None,
            "name": obj.get("name"),
            "url": obj.get("url"),
            "user_refs_results": [UserResults.from_dict(_item) for _item in obj["user_refs_results"]] if obj.get("user_refs_results") is not None else None
        })
        return _obj


