# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from twitter_openapi_python_generated.models.tweet_card_legacy_binding_value_data_image import TweetCardLegacyBindingValueDataImage
from twitter_openapi_python_generated.models.user_value import UserValue
from typing import Optional, Set
from typing_extensions import Self

class TweetCardLegacyBindingValueData(BaseModel):
    """
    TweetCardLegacyBindingValueData
    """ # noqa: E501
    boolean_value: Optional[StrictBool] = None
    image_color_value: Optional[Dict[str, Any]] = None
    image_value: Optional[TweetCardLegacyBindingValueDataImage] = None
    scribe_key: Optional[StrictStr] = None
    string_value: Optional[StrictStr] = None
    type: StrictStr
    user_value: Optional[UserValue] = None
    __properties: ClassVar[List[str]] = ["boolean_value", "image_color_value", "image_value", "scribe_key", "string_value", "type", "user_value"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TweetCardLegacyBindingValueData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image_value
        if self.image_value:
            _dict['image_value'] = self.image_value.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_value
        if self.user_value:
            _dict['user_value'] = self.user_value.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TweetCardLegacyBindingValueData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "boolean_value": obj.get("boolean_value"),
            "image_color_value": obj.get("image_color_value"),
            "image_value": TweetCardLegacyBindingValueDataImage.from_dict(obj["image_value"]) if obj.get("image_value") is not None else None,
            "scribe_key": obj.get("scribe_key"),
            "string_value": obj.get("string_value"),
            "type": obj.get("type"),
            "user_value": UserValue.from_dict(obj["user_value"]) if obj.get("user_value") is not None else None
        })
        return _obj


