# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from twitter_openapi_python_generated.models.client_event_info import ClientEventInfo
from twitter_openapi_python_generated.models.feedback_info import FeedbackInfo
from twitter_openapi_python_generated.models.item_content_union import ItemContentUnion
from typing import Optional, Set
from typing_extensions import Self

class ModuleEntry(BaseModel):
    """
    ModuleEntry
    """ # noqa: E501
    client_event_info: Optional[ClientEventInfo] = Field(default=None, alias="clientEventInfo")
    feedback_info: Optional[FeedbackInfo] = Field(default=None, alias="feedbackInfo")
    item_content: ItemContentUnion = Field(alias="itemContent")
    __properties: ClassVar[List[str]] = ["clientEventInfo", "feedbackInfo", "itemContent"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModuleEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of client_event_info
        if self.client_event_info:
            _dict['clientEventInfo'] = self.client_event_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of feedback_info
        if self.feedback_info:
            _dict['feedbackInfo'] = self.feedback_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of item_content
        if self.item_content:
            _dict['itemContent'] = self.item_content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModuleEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientEventInfo": ClientEventInfo.from_dict(obj["clientEventInfo"]) if obj.get("clientEventInfo") is not None else None,
            "feedbackInfo": FeedbackInfo.from_dict(obj["feedbackInfo"]) if obj.get("feedbackInfo") is not None else None,
            "itemContent": ItemContentUnion.from_dict(obj["itemContent"]) if obj.get("itemContent") is not None else None
        })
        return _obj


